"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .customfieldoptionobject import (
    CustomFieldOptionObject,
    CustomFieldOptionObjectTypedDict,
)
from datetime import datetime
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class UserFieldObjectRelationshipFilterTypedDict(TypedDict):
    r"""A filter definition that allows your autocomplete to filter down results"""


class UserFieldObjectRelationshipFilter(BaseModel):
    r"""A filter definition that allows your autocomplete to filter down results"""


class UserFieldObjectTypedDict(TypedDict):
    key: str
    r"""A unique key that identifies this custom field. This is used for updating the field and referencing in placeholders. The key must consist of only letters, numbers, and underscores. It can't be only numbers"""
    title: str
    r"""The title of the custom field"""
    type: str
    r"""The custom field type: \"checkbox\", \"date\", \"decimal\", \"dropdown\", \"integer\", [\"lookup\"](/api-reference/ticketing/lookup_relationships/lookup_relationships/), \"multiselect\", \"regexp\", \"text\", or \"textarea\" """
    active: NotRequired[bool]
    r"""If true, this field is available for use"""
    created_at: NotRequired[datetime]
    r"""The time of the last update of the ticket field"""
    custom_field_options: NotRequired[List[CustomFieldOptionObjectTypedDict]]
    r"""Required and presented for a custom field of type \"dropdown\". Each option is represented by an object with a `name` and `value` property"""
    description: NotRequired[str]
    r"""User-defined description of this field's purpose"""
    id: NotRequired[int]
    r"""Automatically assigned upon creation"""
    position: NotRequired[int]
    r"""Ordering of the field relative to other fields"""
    raw_description: NotRequired[str]
    r"""The dynamic content placeholder, if present, or the `description` value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""
    raw_title: NotRequired[str]
    r"""The dynamic content placeholder, if present, or the `title` value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""
    regexp_for_validation: NotRequired[Nullable[str]]
    r"""Regular expression field only. The validation pattern for a field value to be deemed valid"""
    relationship_filter: NotRequired[UserFieldObjectRelationshipFilterTypedDict]
    r"""A filter definition that allows your autocomplete to filter down results"""
    relationship_target_type: NotRequired[str]
    r"""A representation of what type of object the field references. Options are \"zen:user\", \"zen:organization\", \"zen:ticket\", and \"zen:custom_object:{key}\" where key is a custom object key. For example \"zen:custom_object:apartment\"."""
    system: NotRequired[bool]
    r"""If true, only active and position values of this field can be changed"""
    tag: NotRequired[str]
    r"""Optional for custom field of type \"checkbox\"; not presented otherwise."""
    updated_at: NotRequired[datetime]
    r"""The time of the last update of the ticket field"""
    url: NotRequired[str]
    r"""The URL for this resource"""


class UserFieldObject(BaseModel):
    key: str
    r"""A unique key that identifies this custom field. This is used for updating the field and referencing in placeholders. The key must consist of only letters, numbers, and underscores. It can't be only numbers"""

    title: str
    r"""The title of the custom field"""

    type: str
    r"""The custom field type: \"checkbox\", \"date\", \"decimal\", \"dropdown\", \"integer\", [\"lookup\"](/api-reference/ticketing/lookup_relationships/lookup_relationships/), \"multiselect\", \"regexp\", \"text\", or \"textarea\" """

    active: Optional[bool] = None
    r"""If true, this field is available for use"""

    created_at: Optional[datetime] = None
    r"""The time of the last update of the ticket field"""

    custom_field_options: Optional[List[CustomFieldOptionObject]] = None
    r"""Required and presented for a custom field of type \"dropdown\". Each option is represented by an object with a `name` and `value` property"""

    description: Optional[str] = None
    r"""User-defined description of this field's purpose"""

    id: Optional[int] = None
    r"""Automatically assigned upon creation"""

    position: Optional[int] = None
    r"""Ordering of the field relative to other fields"""

    raw_description: Optional[str] = None
    r"""The dynamic content placeholder, if present, or the `description` value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""

    raw_title: Optional[str] = None
    r"""The dynamic content placeholder, if present, or the `title` value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)"""

    regexp_for_validation: OptionalNullable[str] = UNSET
    r"""Regular expression field only. The validation pattern for a field value to be deemed valid"""

    relationship_filter: Optional[UserFieldObjectRelationshipFilter] = None
    r"""A filter definition that allows your autocomplete to filter down results"""

    relationship_target_type: Optional[str] = None
    r"""A representation of what type of object the field references. Options are \"zen:user\", \"zen:organization\", \"zen:ticket\", and \"zen:custom_object:{key}\" where key is a custom object key. For example \"zen:custom_object:apartment\"."""

    system: Optional[bool] = None
    r"""If true, only active and position values of this field can be changed"""

    tag: Optional[str] = None
    r"""Optional for custom field of type \"checkbox\"; not presented otherwise."""

    updated_at: Optional[datetime] = None
    r"""The time of the last update of the ticket field"""

    url: Optional[str] = None
    r"""The URL for this resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "active",
            "created_at",
            "custom_field_options",
            "description",
            "id",
            "position",
            "raw_description",
            "raw_title",
            "regexp_for_validation",
            "relationship_filter",
            "relationship_target_type",
            "system",
            "tag",
            "updated_at",
            "url",
        ]
        nullable_fields = ["regexp_for_validation"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
