"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class ViewCountObjectTypedDict(TypedDict):
    active: NotRequired[bool]
    r"""Only active views if true, inactive views if false, all views if null."""
    fresh: NotRequired[bool]
    r"""false if the cached data is stale and the system is still loading and caching new data"""
    pretty: NotRequired[str]
    r"""A pretty-printed text approximation of the view count"""
    url: NotRequired[str]
    r"""The API url of the count"""
    value: NotRequired[Nullable[int]]
    r"""The cached number of tickets in the view. Can also be null if the system is loading and caching new data. Not to be confused with 0 tickets"""
    view_id: NotRequired[int]
    r"""The id of the view"""


class ViewCountObject(BaseModel):
    active: Optional[bool] = None
    r"""Only active views if true, inactive views if false, all views if null."""

    fresh: Optional[bool] = None
    r"""false if the cached data is stale and the system is still loading and caching new data"""

    pretty: Optional[str] = None
    r"""A pretty-printed text approximation of the view count"""

    url: Optional[str] = None
    r"""The API url of the count"""

    value: OptionalNullable[int] = UNSET
    r"""The cached number of tickets in the view. Can also be null if the system is loading and caching new data. Not to be confused with 0 tickets"""

    view_id: Optional[int] = None
    r"""The id of the view"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["active", "fresh", "pretty", "url", "value", "view_id"]
        nullable_fields = ["value"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
