"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .attachmentbaseobject import AttachmentBaseObject, AttachmentBaseObjectTypedDict
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class AttachmentObjectTypedDict(TypedDict):
    r"""A file represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/) object"""

    content_type: NotRequired[str]
    r"""The content type of the image. Example value: \"image/png\" """
    content_url: NotRequired[str]
    r"""A full URL where the attachment image file can be downloaded. The file may be hosted externally so take care not to inadvertently send Zendesk authentication credentials. See [Working with url properties](/documentation/ticketing/managing-tickets/working-with-url-properties)"""
    deleted: NotRequired[bool]
    r"""If true, the attachment has been deleted"""
    file_name: NotRequired[str]
    r"""The name of the image file"""
    height: NotRequired[int]
    r"""The height of the image file in pixels. If height is unknown, returns null"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""
    inline: NotRequired[bool]
    r"""If true, the attachment is excluded from the attachment list and the attachment's URL
    can be referenced within the comment of a ticket. Default is false

    """
    malware_access_override: NotRequired[bool]
    r"""If true, you can download an attachment flagged as malware. If false, you can't download such an attachment."""
    malware_scan_result: NotRequired[str]
    r"""The result of the malware scan. There is a delay between the time the attachment is uploaded and when the malware scan is completed. Usually the scan is done within a few seconds, but high load conditions can delay the scan results. Possible values: \"malware_found\", \"malware_not_found\", \"failed_to_scan\", \"not_scanned\" """
    mapped_content_url: NotRequired[str]
    r"""The URL the attachment image file has been mapped to"""
    size: NotRequired[int]
    r"""The size of the image file in bytes"""
    url: NotRequired[str]
    r"""A URL to access the attachment details"""
    width: NotRequired[int]
    r"""The width of the image file in pixels. If width is unknown, returns null"""
    thumbnails: NotRequired[List[AttachmentBaseObjectTypedDict]]
    r"""An array of attachment objects. Note that photo thumbnails do not have thumbnails"""


class AttachmentObject(BaseModel):
    r"""A file represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/) object"""

    content_type: Optional[str] = None
    r"""The content type of the image. Example value: \"image/png\" """

    content_url: Optional[str] = None
    r"""A full URL where the attachment image file can be downloaded. The file may be hosted externally so take care not to inadvertently send Zendesk authentication credentials. See [Working with url properties](/documentation/ticketing/managing-tickets/working-with-url-properties)"""

    deleted: Optional[bool] = None
    r"""If true, the attachment has been deleted"""

    file_name: Optional[str] = None
    r"""The name of the image file"""

    height: Optional[int] = None
    r"""The height of the image file in pixels. If height is unknown, returns null"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    inline: Optional[bool] = None
    r"""If true, the attachment is excluded from the attachment list and the attachment's URL
    can be referenced within the comment of a ticket. Default is false

    """

    malware_access_override: Optional[bool] = None
    r"""If true, you can download an attachment flagged as malware. If false, you can't download such an attachment."""

    malware_scan_result: Optional[str] = None
    r"""The result of the malware scan. There is a delay between the time the attachment is uploaded and when the malware scan is completed. Usually the scan is done within a few seconds, but high load conditions can delay the scan results. Possible values: \"malware_found\", \"malware_not_found\", \"failed_to_scan\", \"not_scanned\" """

    mapped_content_url: Optional[str] = None
    r"""The URL the attachment image file has been mapped to"""

    size: Optional[int] = None
    r"""The size of the image file in bytes"""

    url: Optional[str] = None
    r"""A URL to access the attachment details"""

    width: Optional[int] = None
    r"""The width of the image file in pixels. If width is unknown, returns null"""

    thumbnails: Optional[List[AttachmentBaseObject]] = None
    r"""An array of attachment objects. Note that photo thumbnails do not have thumbnails"""
