"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .attachmentobject import AttachmentObject, AttachmentObjectTypedDict
from .attributevalueobject import AttributeValueObject, AttributeValueObjectTypedDict
from .viaobject import ViaObject, ViaObjectTypedDict
from datetime import datetime
from pydantic import Discriminator, Tag, model_serializer
from typing import Any, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from zendesk.utils import get_discriminator


TypeRoutingChannelEvent = Literal["RoutingChannelEvent",]


class RoutingChannelEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeRoutingChannelEvent
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    previous: NotRequired[str]
    r"""The previous routing channel"""
    current: NotRequired[str]
    r"""The current routing channel"""


class RoutingChannelEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeRoutingChannelEvent

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    previous: Optional[str] = None
    r"""The previous routing channel"""

    current: Optional[str] = None
    r"""The current routing channel"""


TypeOfferedToEvent = Literal["OfferedToEvent",]


class OfferedToEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeOfferedToEvent
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    assignee: NotRequired[int]
    r"""The id of the agent the ticket was offered to"""
    skills: NotRequired[List[AttributeValueObjectTypedDict]]
    r"""Skills used to route the ticket to an agent"""


class OfferedToEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeOfferedToEvent

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    assignee: Optional[int] = None
    r"""The id of the agent the ticket was offered to"""

    skills: Optional[List[AttributeValueObject]] = None
    r"""Skills used to route the ticket to an agent"""


TypeSurveyResponseSubmitted = Literal["SurveyResponseSubmitted",]


class SurveyResponseSubmittedEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeSurveyResponseSubmitted
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    assigned_user_id: NotRequired[Nullable[int]]
    r"""The id of the user assigned to the ticket at the time the survey response was submitted"""
    assigned_group_id: NotRequired[Nullable[int]]
    r"""The id of the group assigned to the ticket at the time the survey response was submitted"""
    survey_response_id: NotRequired[str]
    r"""A ULID representing the survey response that was submitted"""
    survey_type: NotRequired[str]
    r"""The type of the survey that was offered"""


class SurveyResponseSubmittedEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeSurveyResponseSubmitted

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    assigned_user_id: OptionalNullable[int] = UNSET
    r"""The id of the user assigned to the ticket at the time the survey response was submitted"""

    assigned_group_id: OptionalNullable[int] = UNSET
    r"""The id of the group assigned to the ticket at the time the survey response was submitted"""

    survey_response_id: Optional[str] = None
    r"""A ULID representing the survey response that was submitted"""

    survey_type: Optional[str] = None
    r"""The type of the survey that was offered"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "via",
            "assigned_user_id",
            "assigned_group_id",
            "survey_response_id",
            "survey_type",
        ]
        nullable_fields = ["assigned_user_id", "assigned_group_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


TypeSurveyOffered = Literal["SurveyOffered",]


class SurveyOfferedEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeSurveyOffered
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    assigned_user_id: NotRequired[Nullable[int]]
    r"""The id of the user assigned to the ticket at the time the survey was offered"""
    assigned_group_id: NotRequired[Nullable[int]]
    r"""The id of the group assigned to the ticket at the time the survey was offered"""
    survey_id: NotRequired[str]
    r"""A ULID representing the survey that was offered"""
    survey_type: NotRequired[str]
    r"""The type of the survey that was offered"""


class SurveyOfferedEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeSurveyOffered

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    assigned_user_id: OptionalNullable[int] = UNSET
    r"""The id of the user assigned to the ticket at the time the survey was offered"""

    assigned_group_id: OptionalNullable[int] = UNSET
    r"""The id of the group assigned to the ticket at the time the survey was offered"""

    survey_id: Optional[str] = None
    r"""A ULID representing the survey that was offered"""

    survey_type: Optional[str] = None
    r"""The type of the survey that was offered"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "via",
            "assigned_user_id",
            "assigned_group_id",
            "survey_id",
            "survey_type",
        ]
        nullable_fields = ["assigned_user_id", "assigned_group_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


TypeAssociateAttValsEvent = Literal["AssociateAttValsEvent",]


class SkillAssignedEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeAssociateAttValsEvent
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    attribute_values: NotRequired[List[AttributeValueObjectTypedDict]]
    r"""Skills assigned to the ticket"""


class SkillAssignedEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeAssociateAttValsEvent

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    attribute_values: Optional[List[AttributeValueObject]] = None
    r"""Skills assigned to the ticket"""


TypeChatEndedEvent = Literal["ChatEndedEvent",]


class ChatEndedEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeChatEndedEvent
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    value: NotRequired[List[Any]]
    r"""Properties of the messaging conversation"""
    attachments: NotRequired[List[AttachmentObjectTypedDict]]


class ChatEndedEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeChatEndedEvent

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    value: Optional[List[Any]] = None
    r"""Properties of the messaging conversation"""

    attachments: Optional[List[AttachmentObject]] = None


TypeChatStartedEvent = Literal["ChatStartedEvent",]


class ChatStartedEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeChatStartedEvent
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    value: NotRequired[List[Any]]
    r"""Properties of the messaging conversation"""
    history: NotRequired[List[Any]]
    r"""Data about chat events"""
    webpath: NotRequired[List[Any]]
    r"""The webpath for the messaging conversation"""
    attachments: NotRequired[List[AttachmentObjectTypedDict]]


class ChatStartedEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeChatStartedEvent

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    value: Optional[List[Any]] = None
    r"""Properties of the messaging conversation"""

    history: Optional[List[Any]] = None
    r"""Data about chat events"""

    webpath: Optional[List[Any]] = None
    r"""The webpath for the messaging conversation"""

    attachments: Optional[List[AttachmentObject]] = None


TypePush = Literal["Push",]


class PushEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypePush
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    value: NotRequired[str]
    r"""Data being pushed out of our system"""
    value_reference: NotRequired[str]
    r"""A reference to the destination of the data"""


class PushEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypePush

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    value: Optional[str] = None
    r"""Data being pushed out of our system"""

    value_reference: Optional[str] = None
    r"""A reference to the destination of the data"""


TypeLogMeInTranscript = Literal["LogMeInTranscript",]


class LogMeInTranscriptEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeLogMeInTranscript
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    body: NotRequired[str]
    r"""An audit of the transcript"""


class LogMeInTranscriptEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeLogMeInTranscript

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    body: Optional[str] = None
    r"""An audit of the transcript"""


TypeExternal = Literal["External",]


class ExternalEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeExternal
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    resource: NotRequired[str]
    r"""External target id"""
    body: NotRequired[str]
    r"""Trigger message for this target event"""


class ExternalEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeExternal

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    resource: Optional[str] = None
    r"""External target id"""

    body: Optional[str] = None
    r"""Trigger message for this target event"""


TypeFacebookComment = Literal["FacebookComment",]


class DataFacebookCommentTypedDict(TypedDict):
    r"""Properties of the Facebook comment"""


class DataFacebookComment(BaseModel):
    r"""Properties of the Facebook comment"""


class FacebookCommentEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeFacebookComment
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    data: NotRequired[DataFacebookCommentTypedDict]
    r"""Properties of the Facebook comment"""
    body: NotRequired[str]
    r"""The actual comment made by the author"""
    html_body: NotRequired[str]
    r"""The actual comment made by the author formatted as HTML"""
    public: NotRequired[bool]
    r"""If this is a public comment or an internal-agents-only note"""
    trusted: NotRequired[bool]
    r"""If this comment is trusted or marked as being potentially fraudulent"""
    author_id: NotRequired[int]
    r"""The id of the author of this comment"""
    graph_object_id: NotRequired[str]
    r"""The graph object id of the associated Facebook Wall post or message"""


class FacebookCommentEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeFacebookComment

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    data: Optional[DataFacebookComment] = None
    r"""Properties of the Facebook comment"""

    body: Optional[str] = None
    r"""The actual comment made by the author"""

    html_body: Optional[str] = None
    r"""The actual comment made by the author formatted as HTML"""

    public: Optional[bool] = None
    r"""If this is a public comment or an internal-agents-only note"""

    trusted: Optional[bool] = None
    r"""If this comment is trusted or marked as being potentially fraudulent"""

    author_id: Optional[int] = None
    r"""The id of the author of this comment"""

    graph_object_id: Optional[str] = None
    r"""The graph object id of the associated Facebook Wall post or message"""


TypeFacebookEvent = Literal["FacebookEvent",]


class PageTypedDict(TypedDict):
    r"""The name and graph id of the Facebook Page associated with the event"""


class Page(BaseModel):
    r"""The name and graph id of the Facebook Page associated with the event"""


TicketVia = Literal[
    "post",
    "message",
]
r"""Post or message depending on the association"""


class FacebookEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeFacebookEvent
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    page: NotRequired[PageTypedDict]
    r"""The name and graph id of the Facebook Page associated with the event"""
    communication: NotRequired[int]
    r"""The Zendesk Support id of the associated communication"""
    ticket_via: NotRequired[TicketVia]
    r"""Post or message depending on the association"""
    body: NotRequired[str]
    r"""The value of the message posted to Facebook"""


class FacebookEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeFacebookEvent

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    page: Optional[Page] = None
    r"""The name and graph id of the Facebook Page associated with the event"""

    communication: Optional[int] = None
    r"""The Zendesk Support id of the associated communication"""

    ticket_via: Optional[TicketVia] = None
    r"""Post or message depending on the association"""

    body: Optional[str] = None
    r"""The value of the message posted to Facebook"""


TypeTweet = Literal["Tweet",]


class TweetEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeTweet
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    direct_message: NotRequired[bool]
    r"""Whether this tweet was a direct message"""
    body: NotRequired[str]
    r"""The body of the tweet"""
    recipients: NotRequired[List[int]]
    r"""An array of recipient IDs"""


class TweetEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeTweet

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    direct_message: Optional[bool] = None
    r"""Whether this tweet was a direct message"""

    body: Optional[str] = None
    r"""The body of the tweet"""

    recipients: Optional[List[int]] = None
    r"""An array of recipient IDs"""


TypeErrorT = Literal["Error",]


class ErrorEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeErrorT
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    message: NotRequired[str]
    r"""The error message"""


class ErrorEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeErrorT

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    message: Optional[str] = None
    r"""The error message"""


TypeOrganizationActivity = Literal["OrganizationActivity",]


class OrganizationSubscriptionNotificationEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeOrganizationActivity
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    subject: NotRequired[str]
    r"""The subject of the message sent to the recipients"""
    body: NotRequired[str]
    r"""The message sent to the recipients"""
    recipients: NotRequired[List[int]]
    r"""An array of recipient IDs"""


class OrganizationSubscriptionNotificationEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeOrganizationActivity

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    subject: Optional[str] = None
    r"""The subject of the message sent to the recipients"""

    body: Optional[str] = None
    r"""The message sent to the recipients"""

    recipients: Optional[List[int]] = None
    r"""An array of recipient IDs"""


TypeTicketSharingEvent = Literal["TicketSharingEvent",]


AuditEventAction = Literal[
    "shared",
    "unshared",
]
r"""The sharing action"""


class TicketSharingEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeTicketSharingEvent
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    agreement_id: NotRequired[int]
    r"""The sharing agreement id"""
    action: NotRequired[AuditEventAction]
    r"""The sharing action"""


class TicketSharingEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeTicketSharingEvent

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    agreement_id: Optional[int] = None
    r"""The sharing agreement id"""

    action: Optional[AuditEventAction] = None
    r"""The sharing action"""


TypeSatisfactionRating = Literal["SatisfactionRating",]


Score = Literal[
    "offered",
    "unoffered",
    "good",
    "bad",
]
r"""The rating state"""


class SatisfactionRatingEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeSatisfactionRating
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    score: NotRequired[Score]
    r"""The rating state"""
    assignee_id: NotRequired[int]
    r"""Who the ticket was assigned to upon rating time"""
    body: NotRequired[str]
    r"""The users comment posted during rating"""


class SatisfactionRatingEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeSatisfactionRating

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    score: Optional[Score] = None
    r"""The rating state"""

    assignee_id: Optional[int] = None
    r"""Who the ticket was assigned to upon rating time"""

    body: Optional[str] = None
    r"""The users comment posted during rating"""


TypeMacroReference = Literal["MacroReference",]


class MacroReferenceEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeMacroReference
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    macro_id: NotRequired[int]
    r"""The id of the macro this event refers to"""
    macro_title: NotRequired[str]
    r"""The title of the macro this event refers to"""
    macro_deleted: NotRequired[bool]
    r"""Whether or not the macro this event refers to is deleted"""


class MacroReferenceEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeMacroReference

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    macro_id: Optional[int] = None
    r"""The id of the macro this event refers to"""

    macro_title: Optional[str] = None
    r"""The title of the macro this event refers to"""

    macro_deleted: Optional[bool] = None
    r"""Whether or not the macro this event refers to is deleted"""


TypeEmailCcChange = Literal["EmailCcChange",]


class EmailCcChangeEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeEmailCcChange
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    previous_email_ccs: NotRequired[List[str]]
    r"""The previous email CCs on the ticket"""
    current_email_ccs: NotRequired[List[str]]
    r"""The current email CCs on the ticket"""


class EmailCcChangeEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeEmailCcChange

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    previous_email_ccs: Optional[List[str]] = None
    r"""The previous email CCs on the ticket"""

    current_email_ccs: Optional[List[str]] = None
    r"""The current email CCs on the ticket"""


TypeFollowersChange = Literal["FollowersChange",]


class FollowerChangeEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeFollowersChange
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    previous_followers: NotRequired[List[int]]
    r"""The previous followers on the ticket"""
    current_followers: NotRequired[List[int]]
    r"""The current followers on the ticket"""


class FollowerChangeEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeFollowersChange

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    previous_followers: Optional[List[int]] = None
    r"""The previous followers on the ticket"""

    current_followers: Optional[List[int]] = None
    r"""The current followers on the ticket"""


TypeFollowerNotificationEvent = Literal["FollowerNotificationEvent",]


class FollowerNotificationEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeFollowerNotificationEvent
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    subject: NotRequired[str]
    r"""The subject of the message sent to the recipients"""
    body: NotRequired[str]
    r"""The message sent to the recipients"""
    recipients: NotRequired[List[int]]
    r"""An array of recipient IDs"""


class FollowerNotificationEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeFollowerNotificationEvent

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    subject: Optional[str] = None
    r"""The subject of the message sent to the recipients"""

    body: Optional[str] = None
    r"""The message sent to the recipients"""

    recipients: Optional[List[int]] = None
    r"""An array of recipient IDs"""


TypeCc = Literal["Cc",]


class CcEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeCc
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    body: NotRequired[str]
    r"""The message sent to the recipients"""
    recipients: NotRequired[List[int]]
    r"""An array of recipient IDs"""


class CcEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeCc

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    body: Optional[str] = None
    r"""The message sent to the recipients"""

    recipients: Optional[List[int]] = None
    r"""An array of recipient IDs"""


TypeSmsNotification = Literal["SmsNotification",]


class SmsNotificationEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeSmsNotification
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    body: NotRequired[str]
    r"""The message sent to the recipients"""
    recipients: NotRequired[List[int]]
    r"""An array of recipient IDs"""


class SmsNotificationEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeSmsNotification

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    body: Optional[str] = None
    r"""The message sent to the recipients"""

    recipients: Optional[List[int]] = None
    r"""An array of recipient IDs"""


TypeNotificationWithCcs = Literal["NotificationWithCcs",]


class NotificationWithCcsEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeNotificationWithCcs
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    subject: NotRequired[str]
    r"""The subject of the message sent to the recipients"""
    body: NotRequired[str]
    r"""The message sent to the recipients"""
    recipients: NotRequired[List[int]]
    r"""An array of recipient IDs"""


class NotificationWithCcsEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeNotificationWithCcs

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    subject: Optional[str] = None
    r"""The subject of the message sent to the recipients"""

    body: Optional[str] = None
    r"""The message sent to the recipients"""

    recipients: Optional[List[int]] = None
    r"""An array of recipient IDs"""


TypeNotification = Literal["Notification",]


class NotificationEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeNotification
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    subject: NotRequired[str]
    r"""The subject of the message sent to the recipients"""
    body: NotRequired[str]
    r"""The message sent to the recipients"""
    recipients: NotRequired[List[int]]
    r"""An array of recipient IDs"""


class NotificationEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeNotification

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    subject: Optional[str] = None
    r"""The subject of the message sent to the recipients"""

    body: Optional[str] = None
    r"""The message sent to the recipients"""

    recipients: Optional[List[int]] = None
    r"""An array of recipient IDs"""


TypeSuspendedTicketRecovery = Literal["SuspendedTicketRecovery",]


RecoveryType = Literal[
    "manual",
    "automatic",
]
r"""The type of recovery"""


class SuspendedTicketRecoveryEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeSuspendedTicketRecovery
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    cause: NotRequired[str]
    r"""The details of the suspension"""
    cause_name: NotRequired[str]
    r"""The key of the cause of suspension"""
    cause_id: NotRequired[int]
    r"""The id of the cause of suspension"""
    recovery_details: NotRequired[str]
    r"""The details of the recovery, including the recovery type and the recovery author's name"""
    recovery_type: NotRequired[RecoveryType]
    r"""The type of recovery"""
    recovered_at: NotRequired[datetime]
    r"""The date of recovery"""
    recovered_by: NotRequired[int]
    r"""The user who performed the recovery"""


class SuspendedTicketRecoveryEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeSuspendedTicketRecovery

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    cause: Optional[str] = None
    r"""The details of the suspension"""

    cause_name: Optional[str] = None
    r"""The key of the cause of suspension"""

    cause_id: Optional[int] = None
    r"""The id of the cause of suspension"""

    recovery_details: Optional[str] = None
    r"""The details of the recovery, including the recovery type and the recovery author's name"""

    recovery_type: Optional[RecoveryType] = None
    r"""The type of recovery"""

    recovered_at: Optional[datetime] = None
    r"""The date of recovery"""

    recovered_by: Optional[int] = None
    r"""The user who performed the recovery"""


TypeCommentPrivacyChange = Literal["CommentPrivacyChange",]


class CommentPrivacyChangeEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeCommentPrivacyChange
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    comment_id: NotRequired[int]
    r"""The id of the comment that changed privacy"""
    public: NotRequired[bool]
    r"""Tells if the comment was made public or private"""


class CommentPrivacyChangeEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeCommentPrivacyChange

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    comment_id: Optional[int] = None
    r"""The id of the comment that changed privacy"""

    public: Optional[bool] = None
    r"""Tells if the comment was made public or private"""


TypeVoiceComment = Literal["VoiceComment",]


class DataVoiceCommentTypedDict(TypedDict):
    r"""Properties describing the voice comment"""


class DataVoiceComment(BaseModel):
    r"""Properties describing the voice comment"""


class VoiceCommentEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeVoiceComment
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    data: NotRequired[DataVoiceCommentTypedDict]
    r"""Properties describing the voice comment"""
    formatted_from: NotRequired[str]
    r"""A formatted version of the phone number which dialed the call"""
    formatted_to: NotRequired[str]
    r"""A formatted version of the phone number which answered the call"""
    body: NotRequired[str]
    r"""Comment added to the ticket"""
    html_body: NotRequired[str]
    r"""The comment formatted to HTML"""
    public: NotRequired[bool]
    r"""If true, the ticket requester can see the comment"""
    trusted: NotRequired[bool]
    r"""If this comment is trusted or marked as being potentially fraudulent"""
    author_id: NotRequired[int]
    r"""The comment author, typically the agent assigned to the ticket"""
    transcription_visible: NotRequired[bool]
    r"""Whether the transcription is visible on the ticket"""
    attachments: NotRequired[List[AttachmentObjectTypedDict]]


class VoiceCommentEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeVoiceComment

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    data: Optional[DataVoiceComment] = None
    r"""Properties describing the voice comment"""

    formatted_from: Optional[str] = None
    r"""A formatted version of the phone number which dialed the call"""

    formatted_to: Optional[str] = None
    r"""A formatted version of the phone number which answered the call"""

    body: Optional[str] = None
    r"""Comment added to the ticket"""

    html_body: Optional[str] = None
    r"""The comment formatted to HTML"""

    public: Optional[bool] = None
    r"""If true, the ticket requester can see the comment"""

    trusted: Optional[bool] = None
    r"""If this comment is trusted or marked as being potentially fraudulent"""

    author_id: Optional[int] = None
    r"""The comment author, typically the agent assigned to the ticket"""

    transcription_visible: Optional[bool] = None
    r"""Whether the transcription is visible on the ticket"""

    attachments: Optional[List[AttachmentObject]] = None


TypeAttachmentRedactionEvent = Literal["AttachmentRedactionEvent",]


class AttachmentRedactionEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeAttachmentRedactionEvent
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    attachment_id: NotRequired[int]
    r"""The redacted attachment"""
    comment_id: NotRequired[int]
    r"""The comment with the redacted attachment"""


class AttachmentRedactionEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeAttachmentRedactionEvent

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    attachment_id: Optional[int] = None
    r"""The redacted attachment"""

    comment_id: Optional[int] = None
    r"""The comment with the redacted attachment"""


TypeCommentRedactionEvent = Literal["CommentRedactionEvent",]


class CommentRedactionEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeCommentRedactionEvent
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    comment_id: NotRequired[int]
    r"""The comment with the redacted text"""


class CommentRedactionEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeCommentRedactionEvent

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    comment_id: Optional[int] = None
    r"""The comment with the redacted text"""


TypeComment = Literal["Comment",]


class CommentEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeComment
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    body: NotRequired[str]
    r"""The comment body"""
    html_body: NotRequired[str]
    r"""The comment formatted as HTML"""
    public: NotRequired[bool]
    r"""Whether the comment is public"""
    trusted: NotRequired[bool]
    r"""Whether the comment is trusted"""
    author_id: NotRequired[int]
    r"""The comment author ID"""
    attachments: NotRequired[List[AttachmentObjectTypedDict]]


class CommentEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeComment

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    body: Optional[str] = None
    r"""The comment body"""

    html_body: Optional[str] = None
    r"""The comment formatted as HTML"""

    public: Optional[bool] = None
    r"""Whether the comment is public"""

    trusted: Optional[bool] = None
    r"""Whether the comment is trusted"""

    author_id: Optional[int] = None
    r"""The comment author ID"""

    attachments: Optional[List[AttachmentObject]] = None


TypeChange = Literal["Change",]


class ValueChangeTypedDict(TypedDict):
    pass


class ValueChange(BaseModel):
    pass


ValueChangeUnionTypedDict = TypeAliasType(
    "ValueChangeUnionTypedDict", Union[ValueChangeTypedDict, str, List[Any]]
)
r"""The value of the field that was changed"""


ValueChangeUnion = TypeAliasType("ValueChangeUnion", Union[ValueChange, str, List[Any]])
r"""The value of the field that was changed"""


class PreviousValueTypedDict(TypedDict):
    pass


class PreviousValue(BaseModel):
    pass


PreviousValueUnionTypedDict = TypeAliasType(
    "PreviousValueUnionTypedDict", Union[PreviousValueTypedDict, str, List[Any]]
)
r"""The previous value of the field that was changed"""


PreviousValueUnion = TypeAliasType(
    "PreviousValueUnion", Union[PreviousValue, str, List[Any]]
)
r"""The previous value of the field that was changed"""


class ChangeEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeChange
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    field_name: NotRequired[str]
    r"""The name of the field that was changed"""
    value: NotRequired[ValueChangeUnionTypedDict]
    r"""The value of the field that was changed"""
    previous_value: NotRequired[PreviousValueUnionTypedDict]
    r"""The previous value of the field that was changed"""


class ChangeEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeChange

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    field_name: Optional[str] = None
    r"""The name of the field that was changed"""

    value: Optional[ValueChangeUnion] = None
    r"""The value of the field that was changed"""

    previous_value: Optional[PreviousValueUnion] = None
    r"""The previous value of the field that was changed"""


TypeCreate = Literal["Create",]


class ValueCreateTypedDict(TypedDict):
    pass


class ValueCreate(BaseModel):
    pass


ValueCreateUnionTypedDict = TypeAliasType(
    "ValueCreateUnionTypedDict", Union[ValueCreateTypedDict, str, List[Any]]
)
r"""The value of the field that was set"""


ValueCreateUnion = TypeAliasType("ValueCreateUnion", Union[ValueCreate, str, List[Any]])
r"""The value of the field that was set"""


class CreateEventTypedDict(TypedDict):
    id: int
    r"""Automatically assigned when the event is created"""
    type: TypeCreate
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
    field_name: NotRequired[str]
    r"""The name of the field that was set"""
    value: NotRequired[ValueCreateUnionTypedDict]
    r"""The value of the field that was set"""


class CreateEvent(BaseModel):
    id: int
    r"""Automatically assigned when the event is created"""

    type: TypeCreate

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """

    field_name: Optional[str] = None
    r"""The name of the field that was set"""

    value: Optional[ValueCreateUnion] = None
    r"""The value of the field that was set"""


AuditEventTypedDict = TypeAliasType(
    "AuditEventTypedDict",
    Union[
        SkillAssignedEventTypedDict,
        ErrorEventTypedDict,
        LogMeInTranscriptEventTypedDict,
        CommentRedactionEventTypedDict,
        AttachmentRedactionEventTypedDict,
        TicketSharingEventTypedDict,
        CommentPrivacyChangeEventTypedDict,
        ChatEndedEventTypedDict,
        CreateEventTypedDict,
        PushEventTypedDict,
        SmsNotificationEventTypedDict,
        CcEventTypedDict,
        OfferedToEventTypedDict,
        FollowerChangeEventTypedDict,
        EmailCcChangeEventTypedDict,
        ExternalEventTypedDict,
        RoutingChannelEventTypedDict,
        NotificationEventTypedDict,
        NotificationWithCcsEventTypedDict,
        SatisfactionRatingEventTypedDict,
        TweetEventTypedDict,
        OrganizationSubscriptionNotificationEventTypedDict,
        ChangeEventTypedDict,
        MacroReferenceEventTypedDict,
        FollowerNotificationEventTypedDict,
        FacebookEventTypedDict,
        ChatStartedEventTypedDict,
        SurveyOfferedEventTypedDict,
        SurveyResponseSubmittedEventTypedDict,
        CommentEventTypedDict,
        SuspendedTicketRecoveryEventTypedDict,
        FacebookCommentEventTypedDict,
        VoiceCommentEventTypedDict,
    ],
)


AuditEvent = Annotated[
    Union[
        Annotated[CreateEvent, Tag("Create")],
        Annotated[ChangeEvent, Tag("Change")],
        Annotated[CommentEvent, Tag("Comment")],
        Annotated[CommentRedactionEvent, Tag("CommentRedactionEvent")],
        Annotated[AttachmentRedactionEvent, Tag("AttachmentRedactionEvent")],
        Annotated[VoiceCommentEvent, Tag("VoiceComment")],
        Annotated[CommentPrivacyChangeEvent, Tag("CommentPrivacyChange")],
        Annotated[SuspendedTicketRecoveryEvent, Tag("SuspendedTicketRecovery")],
        Annotated[NotificationEvent, Tag("Notification")],
        Annotated[NotificationWithCcsEvent, Tag("NotificationWithCcs")],
        Annotated[SmsNotificationEvent, Tag("SmsNotification")],
        Annotated[CcEvent, Tag("Cc")],
        Annotated[FollowerNotificationEvent, Tag("FollowerNotificationEvent")],
        Annotated[FollowerChangeEvent, Tag("FollowersChange")],
        Annotated[EmailCcChangeEvent, Tag("EmailCcChange")],
        Annotated[MacroReferenceEvent, Tag("MacroReference")],
        Annotated[SatisfactionRatingEvent, Tag("SatisfactionRating")],
        Annotated[TicketSharingEvent, Tag("TicketSharingEvent")],
        Annotated[
            OrganizationSubscriptionNotificationEvent, Tag("OrganizationActivity")
        ],
        Annotated[ErrorEvent, Tag("Error")],
        Annotated[TweetEvent, Tag("Tweet")],
        Annotated[FacebookEvent, Tag("FacebookEvent")],
        Annotated[FacebookCommentEvent, Tag("FacebookComment")],
        Annotated[ExternalEvent, Tag("External")],
        Annotated[LogMeInTranscriptEvent, Tag("LogMeInTranscript")],
        Annotated[PushEvent, Tag("Push")],
        Annotated[ChatStartedEvent, Tag("ChatStartedEvent")],
        Annotated[ChatEndedEvent, Tag("ChatEndedEvent")],
        Annotated[SkillAssignedEvent, Tag("AssociateAttValsEvent")],
        Annotated[SurveyOfferedEvent, Tag("SurveyOffered")],
        Annotated[SurveyResponseSubmittedEvent, Tag("SurveyResponseSubmitted")],
        Annotated[OfferedToEvent, Tag("OfferedToEvent")],
        Annotated[RoutingChannelEvent, Tag("RoutingChannelEvent")],
    ],
    Discriminator(lambda m: get_discriminator(m, "type", "type")),
]
