"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .actionobject import ActionObject, ActionObjectTypedDict
from .conditionsobject import ConditionsObject, ConditionsObjectTypedDict
from datetime import datetime
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class AutomationObjectTypedDict(TypedDict):
    actions: NotRequired[List[ActionObjectTypedDict]]
    r"""An object describing what the automation will do. See [Actions reference](/documentation/ticketing/reference-guides/actions-reference)"""
    active: NotRequired[bool]
    r"""Whether the automation is active"""
    conditions: NotRequired[ConditionsObjectTypedDict]
    r"""An object that describes the conditions under which the automation will execute. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)"""
    created_at: NotRequired[datetime]
    r"""The time the automation was created"""
    default: NotRequired[bool]
    r"""If true, the automation is a default automation"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""
    position: NotRequired[int]
    r"""The position of the automation which specifies the order it will be executed"""
    raw_title: NotRequired[str]
    r"""The raw title of the automation"""
    title: NotRequired[str]
    r"""The title of the automation"""
    updated_at: NotRequired[datetime]
    r"""The time of the last update of the automation"""


class AutomationObject(BaseModel):
    actions: Optional[List[ActionObject]] = None
    r"""An object describing what the automation will do. See [Actions reference](/documentation/ticketing/reference-guides/actions-reference)"""

    active: Optional[bool] = None
    r"""Whether the automation is active"""

    conditions: Optional[ConditionsObject] = None
    r"""An object that describes the conditions under which the automation will execute. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)"""

    created_at: Optional[datetime] = None
    r"""The time the automation was created"""

    default: Optional[bool] = None
    r"""If true, the automation is a default automation"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    position: Optional[int] = None
    r"""The position of the automation which specifies the order it will be executed"""

    raw_title: Optional[str] = None
    r"""The raw title of the automation"""

    title: Optional[str] = None
    r"""The title of the automation"""

    updated_at: Optional[datetime] = None
    r"""The time of the last update of the automation"""
