"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from typing import Callable, List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


class ListTriggerCategoriesPageTypedDict(TypedDict):
    r"""Pagination parameters"""

    after: NotRequired[str]
    before: NotRequired[str]
    size: NotRequired[int]


class ListTriggerCategoriesPage(BaseModel):
    r"""Pagination parameters"""

    after: Annotated[Optional[str], FieldMetadata(query=True)] = None

    before: Annotated[Optional[str], FieldMetadata(query=True)] = None

    size: Annotated[Optional[int], FieldMetadata(query=True)] = None


ListTriggerCategoriesSort = Literal[
    "position",
    "-position",
    "name",
    "-name",
    "created_at",
    "-created_at",
    "updated_at",
    "-updated_at",
]
r"""Sort parameters"""


Include = Literal["rule_counts",]
r"""Allowed sideloads"""


class ListTriggerCategoriesRequestTypedDict(TypedDict):
    page_before: NotRequired[str]
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """
    page_after: NotRequired[str]
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """
    page_size: NotRequired[int]
    r"""Specifies how many records should be returned in the response. You can specify up to 100 records per page.

    """
    page: NotRequired[ListTriggerCategoriesPageTypedDict]
    r"""Pagination parameters"""
    sort: NotRequired[ListTriggerCategoriesSort]
    r"""Sort parameters"""
    include: NotRequired[Include]
    r"""Allowed sideloads"""


class ListTriggerCategoriesRequest(BaseModel):
    page_before: Annotated[
        Optional[str],
        pydantic.Field(alias="page[before]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """

    page_after: Annotated[
        Optional[str],
        pydantic.Field(alias="page[after]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""Specifies how many records should be returned in the response. You can specify up to 100 records per page.

    """

    page: Annotated[
        Optional[ListTriggerCategoriesPage],
        FieldMetadata(query=QueryParamMetadata(style="deepObject", explode=True)),
    ] = None
    r"""Pagination parameters"""

    sort: Annotated[
        Optional[ListTriggerCategoriesSort],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Sort parameters"""

    include: Annotated[
        Optional[Include],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Allowed sideloads"""


class TriggerCategoryRuleCountsTypedDict(TypedDict):
    active_count: NotRequired[int]
    inactive_count: NotRequired[int]
    created_at: NotRequired[str]
    id: NotRequired[str]
    name: NotRequired[str]
    position: NotRequired[int]
    updated_at: NotRequired[str]


class TriggerCategoryRuleCounts(BaseModel):
    active_count: Optional[int] = None

    inactive_count: Optional[int] = None

    created_at: Optional[str] = None

    id: Optional[str] = None

    name: Optional[str] = None

    position: Optional[int] = None

    updated_at: Optional[str] = None


ListTriggerCategoriesTriggerCategoryTypedDict = TriggerCategoryRuleCountsTypedDict


ListTriggerCategoriesTriggerCategory = TriggerCategoryRuleCounts


class ListTriggerCategoriesLinksTypedDict(TypedDict):
    next: NotRequired[str]
    prev: NotRequired[str]


class ListTriggerCategoriesLinks(BaseModel):
    next: Optional[str] = None

    prev: Optional[str] = None


class ListTriggerCategoriesMetaTypedDict(TypedDict):
    after_cursor: NotRequired[str]
    before_cursor: NotRequired[str]
    has_more: NotRequired[bool]


class ListTriggerCategoriesMeta(BaseModel):
    after_cursor: Optional[str] = None

    before_cursor: Optional[str] = None

    has_more: Optional[bool] = None


class ListTriggerCategoriesResponseBodyTypedDict(TypedDict):
    r"""A paged array of ticket trigger categories"""

    trigger_categories: NotRequired[List[ListTriggerCategoriesTriggerCategoryTypedDict]]
    links: NotRequired[ListTriggerCategoriesLinksTypedDict]
    meta: NotRequired[ListTriggerCategoriesMetaTypedDict]


class ListTriggerCategoriesResponseBody(BaseModel):
    r"""A paged array of ticket trigger categories"""

    trigger_categories: Optional[List[ListTriggerCategoriesTriggerCategory]] = None

    links: Optional[ListTriggerCategoriesLinks] = None

    meta: Optional[ListTriggerCategoriesMeta] = None


class ListTriggerCategoriesResponseTypedDict(TypedDict):
    result: ListTriggerCategoriesResponseBodyTypedDict


class ListTriggerCategoriesResponse(BaseModel):
    next: Callable[[], Optional[ListTriggerCategoriesResponse]]

    result: ListTriggerCategoriesResponseBody
