"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .useridentitiesresponse import (
    UserIdentitiesResponse,
    UserIdentitiesResponseTypedDict,
)
import pydantic
from typing import Callable, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata


ListUserIdentitiesType = Literal[
    "email",
    "facebook",
    "phone_number",
    "sdk",
    "twitter",
    "messaging",
    "microsoft",
]
r"""Filters results by one or more identity types using the format `?type[]={type}&type[]={type}`"""


class ListUserIdentitiesRequestTypedDict(TypedDict):
    user_id: int
    r"""The id of the user"""
    type: NotRequired[ListUserIdentitiesType]
    r"""Filters results by one or more identity types using the format `?type[]={type}&type[]={type}`"""
    page_before: NotRequired[str]
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """
    page_after: NotRequired[str]
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """
    page_size: NotRequired[int]
    r"""Specifies how many records should be returned in the response. You can specify up to 100 records per page.

    """


class ListUserIdentitiesRequest(BaseModel):
    user_id: Annotated[
        int, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The id of the user"""

    type: Annotated[
        Optional[ListUserIdentitiesType],
        pydantic.Field(alias="type[]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters results by one or more identity types using the format `?type[]={type}&type[]={type}`"""

    page_before: Annotated[
        Optional[str],
        pydantic.Field(alias="page[before]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """

    page_after: Annotated[
        Optional[str],
        pydantic.Field(alias="page[after]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""Specifies how many records should be returned in the response. You can specify up to 100 records per page.

    """


class ListUserIdentitiesResponseTypedDict(TypedDict):
    result: UserIdentitiesResponseTypedDict


class ListUserIdentitiesResponse(BaseModel):
    next: Callable[[], Optional[ListUserIdentitiesResponse]]

    result: UserIdentitiesResponse
