"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .webhookinvocationlistresponse import (
    WebhookInvocationListResponse,
    WebhookInvocationListResponseTypedDict,
)
from datetime import datetime
import pydantic
from typing import Callable, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata


ListWebhookInvocationsFilterStatus = Literal[
    "unknown",
    "accepted",
    "success",
    "failed",
    "timeout",
    "circuit broken",
    "throttled",
    "client error",
    "server error",
]
r"""Filters invocations by invocation status"""


ListWebhookInvocationsSort = Literal[
    "latest_completed_at",
    "-latest_completed_at",
]
r"""Defines a invocation attribute to sort invocations"""


class ListWebhookInvocationsRequestTypedDict(TypedDict):
    webhook_id: str
    r"""Webhook id"""
    filter_from_ts: NotRequired[datetime]
    r"""Filters invocations by from timestamp. Use ISO 8601 UTC format"""
    filter_status: NotRequired[ListWebhookInvocationsFilterStatus]
    r"""Filters invocations by invocation status"""
    filter_to_ts: NotRequired[datetime]
    r"""Filters invocations by timestamp. Use ISO 8601 UTC format"""
    page_before: NotRequired[str]
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """
    page_after: NotRequired[str]
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """
    page_size: NotRequired[int]
    r"""Specifies how many records should be returned in the response. You can specify up to 100 records per page.

    """
    sort: NotRequired[ListWebhookInvocationsSort]
    r"""Defines a invocation attribute to sort invocations"""


class ListWebhookInvocationsRequest(BaseModel):
    webhook_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Webhook id"""

    filter_from_ts: Annotated[
        Optional[datetime],
        pydantic.Field(alias="filter[from_ts]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters invocations by from timestamp. Use ISO 8601 UTC format"""

    filter_status: Annotated[
        Optional[ListWebhookInvocationsFilterStatus],
        pydantic.Field(alias="filter[status]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters invocations by invocation status"""

    filter_to_ts: Annotated[
        Optional[datetime],
        pydantic.Field(alias="filter[to_ts]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filters invocations by timestamp. Use ISO 8601 UTC format"""

    page_before: Annotated[
        Optional[str],
        pydantic.Field(alias="page[before]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.before_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """

    page_after: Annotated[
        Optional[str],
        pydantic.Field(alias="page[after]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A [pagination cursor](/documentation/api-basics/pagination/paginating-through-lists-using-cursor-pagination) that tells the endpoint which page to start on. It should be a `meta.after_cursor` value from a previous request. Note: `page[before]` and `page[after]` can't be used together in the same request.

    """

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="page[size]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""Specifies how many records should be returned in the response. You can specify up to 100 records per page.

    """

    sort: Annotated[
        Optional[ListWebhookInvocationsSort],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Defines a invocation attribute to sort invocations"""


class ListWebhookInvocationsResponseTypedDict(TypedDict):
    result: WebhookInvocationListResponseTypedDict


class ListWebhookInvocationsResponse(BaseModel):
    next: Callable[[], Optional[ListWebhookInvocationsResponse]]

    result: WebhookInvocationListResponse
