"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .actionobject import ActionObject, ActionObjectTypedDict
import pydantic
from pydantic import ConfigDict, model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class RestrictionTypedDict(TypedDict):
    r"""Who may access this macro. Will be null when everyone in the account can access it"""

    id: NotRequired[int]
    r"""The numeric ID of the group or user"""
    ids: NotRequired[List[int]]
    r"""The numeric IDs of the groups"""
    type: NotRequired[str]
    r"""Allowed values are Group or User"""


class Restriction(BaseModel):
    r"""Who may access this macro. Will be null when everyone in the account can access it"""

    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    id: Optional[int] = None
    r"""The numeric ID of the group or user"""

    ids: Optional[List[int]] = None
    r"""The numeric IDs of the groups"""

    type: Optional[str] = None
    r"""Allowed values are Group or User"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class MacroInputTypedDict(TypedDict):
    actions: List[ActionObjectTypedDict]
    r"""Each action describes what the macro will do"""
    title: str
    r"""The title of the macro"""
    active: NotRequired[bool]
    r"""Useful for determining if the macro should be displayed"""
    description: NotRequired[Nullable[str]]
    r"""The description of the macro"""
    restriction: NotRequired[RestrictionTypedDict]
    r"""Who may access this macro. Will be null when everyone in the account can access it"""


class MacroInput(BaseModel):
    actions: List[ActionObject]
    r"""Each action describes what the macro will do"""

    title: str
    r"""The title of the macro"""

    active: Optional[bool] = None
    r"""Useful for determining if the macro should be displayed"""

    description: OptionalNullable[str] = UNSET
    r"""The description of the macro"""

    restriction: Optional[Restriction] = None
    r"""Who may access this macro. Will be null when everyone in the account can access it"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["active", "description", "restriction"]
        nullable_fields = ["description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
