"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .triggeractionobject import TriggerActionObject, TriggerActionObjectTypedDict
from .triggerconditionsobject import (
    TriggerConditionsObject,
    TriggerConditionsObjectTypedDict,
)
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class ObjectTriggerObjectTypedDict(TypedDict):
    actions: List[TriggerActionObjectTypedDict]
    r"""An array of actions the trigger does when its conditions are met. See [Actions reference](/documentation/ticketing/reference-guides/actions-reference)"""
    conditions: TriggerConditionsObjectTypedDict
    r"""An object that describes the circumstances under which the trigger performs its actions. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)"""
    title: str
    r"""The title of the trigger"""
    active: NotRequired[bool]
    r"""Whether the trigger is active"""
    created_at: NotRequired[str]
    r"""The time the trigger was created"""
    default: NotRequired[bool]
    r"""Always false for object triggers"""
    description: NotRequired[str]
    r"""The description of the trigger"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""
    position: NotRequired[int]
    r"""Position of the trigger, determines the order they will execute in"""
    raw_title: NotRequired[str]
    r"""The raw format of the title of the trigger"""
    updated_at: NotRequired[str]
    r"""The time of the last update of the trigger"""
    url: NotRequired[str]
    r"""The url of the trigger"""


class ObjectTriggerObject(BaseModel):
    actions: List[TriggerActionObject]
    r"""An array of actions the trigger does when its conditions are met. See [Actions reference](/documentation/ticketing/reference-guides/actions-reference)"""

    conditions: TriggerConditionsObject
    r"""An object that describes the circumstances under which the trigger performs its actions. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)"""

    title: str
    r"""The title of the trigger"""

    active: Optional[bool] = None
    r"""Whether the trigger is active"""

    created_at: Optional[str] = None
    r"""The time the trigger was created"""

    default: Optional[bool] = None
    r"""Always false for object triggers"""

    description: Optional[str] = None
    r"""The description of the trigger"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    position: Optional[int] = None
    r"""Position of the trigger, determines the order they will execute in"""

    raw_title: Optional[str] = None
    r"""The raw format of the title of the trigger"""

    updated_at: Optional[str] = None
    r"""The time of the last update of the trigger"""

    url: Optional[str] = None
    r"""The url of the trigger"""
