"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .triggersearchfilter import TriggerSearchFilter, TriggerSearchFilterTypedDict
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


class SearchTriggersRequestTypedDict(TypedDict):
    query: str
    r"""Query string used to find all triggers with matching title"""
    filter_: NotRequired[TriggerSearchFilterTypedDict]
    r"""Trigger attribute filters for the search. See [Filter](#filter)"""
    active: NotRequired[bool]
    r"""Filter by active triggers if true or inactive triggers if false"""
    sort: NotRequired[str]
    r"""Cursor-based pagination only. Possible values are \"alphabetical\", \"created_at\", \"updated_at\", or \"position\"."""
    sort_by: NotRequired[str]
    r"""Offset pagination only. Possible values are \"alphabetical\", \"created_at\", \"updated_at\", \"usage_1h\", \"usage_24h\", or \"usage_7d\". Defaults to \"position\" """
    sort_order: NotRequired[str]
    r"""One of \"asc\" or \"desc\". Defaults to \"asc\" for alphabetical and position sort, \"desc\" for all others"""
    include: NotRequired[str]
    r"""A sideload to include in the response. See [Sideloads](#sideloads-2)"""


class SearchTriggersRequest(BaseModel):
    query: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""Query string used to find all triggers with matching title"""

    filter_: Annotated[
        Optional[TriggerSearchFilter],
        pydantic.Field(alias="filter"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Trigger attribute filters for the search. See [Filter](#filter)"""

    active: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter by active triggers if true or inactive triggers if false"""

    sort: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Cursor-based pagination only. Possible values are \"alphabetical\", \"created_at\", \"updated_at\", or \"position\"."""

    sort_by: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Offset pagination only. Possible values are \"alphabetical\", \"created_at\", \"updated_at\", \"usage_1h\", \"usage_24h\", or \"usage_7d\". Defaults to \"position\" """

    sort_order: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""One of \"asc\" or \"desc\". Defaults to \"asc\" for alphabetical and position sort, \"desc\" for all others"""

    include: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A sideload to include in the response. See [Sideloads](#sideloads-2)"""
