"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .slapolicyfilterobject import SLAPolicyFilterObject, SLAPolicyFilterObjectTypedDict
from .slapolicymetricobject import SLAPolicyMetricObject, SLAPolicyMetricObjectTypedDict
from datetime import datetime
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel


class SLAPolicyObjectTypedDict(TypedDict):
    filter_: SLAPolicyFilterObjectTypedDict
    r"""An object that describes the conditions that a ticket must match in order for an SLA policy to be applied to that ticket. See [Filter](#filter)."""
    title: str
    r"""The title of the SLA policy"""
    created_at: NotRequired[datetime]
    r"""The time the SLA policy was created"""
    description: NotRequired[str]
    r"""The description of the SLA policy"""
    id: NotRequired[int]
    r"""Automatically assigned when created"""
    policy_metrics: NotRequired[List[SLAPolicyMetricObjectTypedDict]]
    r"""Array of [Policy Metric](#policy-metric) objects"""
    position: NotRequired[int]
    r"""Position of the SLA policy that determines the order they will be matched. If not specified, the SLA policy is added as the last position"""
    updated_at: NotRequired[datetime]
    r"""The time of the last update of the SLA policy"""
    url: NotRequired[str]
    r"""URL of the SLA Policy reacord"""


class SLAPolicyObject(BaseModel):
    filter_: Annotated[SLAPolicyFilterObject, pydantic.Field(alias="filter")]
    r"""An object that describes the conditions that a ticket must match in order for an SLA policy to be applied to that ticket. See [Filter](#filter)."""

    title: str
    r"""The title of the SLA policy"""

    created_at: Optional[datetime] = None
    r"""The time the SLA policy was created"""

    description: Optional[str] = None
    r"""The description of the SLA policy"""

    id: Optional[int] = None
    r"""Automatically assigned when created"""

    policy_metrics: Optional[List[SLAPolicyMetricObject]] = None
    r"""Array of [Policy Metric](#policy-metric) objects"""

    position: Optional[int] = None
    r"""Position of the SLA policy that determines the order they will be matched. If not specified, the SLA policy is added as the last position"""

    updated_at: Optional[datetime] = None
    r"""The time of the last update of the SLA policy"""

    url: Optional[str] = None
    r"""URL of the SLA Policy reacord"""
