"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .collaboratorobject import CollaboratorObject, CollaboratorObjectTypedDict
from .emailccobject import EmailCCObject, EmailCCObjectTypedDict
from .followerobject import FollowerObject, FollowerObjectTypedDict
from .ticketcommentobject_input import (
    TicketCommentObjectInput,
    TicketCommentObjectInputTypedDict,
)
from datetime import datetime
from pydantic import model_serializer
from typing import List, Literal, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


TicketCreateInputValueTypedDict = TypeAliasType(
    "TicketCreateInputValueTypedDict", Union[str, int, bool, List[str]]
)
r"""The value of the custom field"""


TicketCreateInputValue = TypeAliasType(
    "TicketCreateInputValue", Union[str, int, bool, List[str]]
)
r"""The value of the custom field"""


class TicketCreateInputCustomFieldTypedDict(TypedDict):
    id: NotRequired[int]
    r"""The id of the custom field"""
    value: NotRequired[TicketCreateInputValueTypedDict]
    r"""The value of the custom field"""


class TicketCreateInputCustomField(BaseModel):
    id: Optional[int] = None
    r"""The id of the custom field"""

    value: Optional[TicketCreateInputValue] = None
    r"""The value of the custom field"""


TicketCreateInputPriority = Literal[
    "urgent",
    "high",
    "normal",
    "low",
]
r"""The urgency with which the ticket should be addressed."""


TicketCreateInputStatus = Literal[
    "new",
    "open",
    "pending",
    "hold",
    "solved",
    "closed",
]
r"""The state of the ticket.

If your account has activated custom ticket statuses, this is the ticket's
status category. See [custom ticket statuses](#custom-ticket-statuses).

"""


TicketCreateInputType = Literal[
    "problem",
    "incident",
    "question",
    "task",
]
r"""The type of this ticket."""


class TicketCreateInputTypedDict(TypedDict):
    comment: TicketCommentObjectInputTypedDict
    additional_collaborators: NotRequired[List[CollaboratorObjectTypedDict]]
    r"""An array of numeric IDs, emails, or objects containing name and email properties. See [Setting Collaborators](/api-reference/ticketing/tickets/tickets/#setting-collaborators). An email notification is sent to them when the ticket is updated"""
    assignee_email: NotRequired[str]
    r"""The email address of the agent to assign the ticket to"""
    assignee_id: NotRequired[int]
    r"""The agent currently assigned to the ticket"""
    attribute_value_ids: NotRequired[List[int]]
    r"""An array of the IDs of attribute values to be associated with the ticket"""
    collaborator_ids: NotRequired[List[int]]
    r"""The ids of users currently CC'ed on the ticket"""
    custom_fields: NotRequired[List[TicketCreateInputCustomFieldTypedDict]]
    r"""Custom fields for the ticket. See [Setting custom field values](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-custom-field-values)"""
    custom_status_id: NotRequired[int]
    r"""The custom ticket status id of the ticket. See [custom ticket statuses](#custom-ticket-statuses)"""
    due_at: NotRequired[Nullable[datetime]]
    r"""If this is a ticket of type \"task\" it has a due date.  Due date format uses [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format."""
    email_ccs: NotRequired[List[EmailCCObjectTypedDict]]
    r"""An array of objects that represent agent or end users email CCs to add or delete from the ticket. See [Setting email CCs](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-email-ccs)"""
    external_id: NotRequired[str]
    r"""An id you can use to link Zendesk Support tickets to local records"""
    followers: NotRequired[List[FollowerObjectTypedDict]]
    r"""An array of objects that represent agent followers to add or delete from the ticket. See [Setting followers](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-followers)"""
    group_id: NotRequired[int]
    r"""The group this ticket is assigned to"""
    organization_id: NotRequired[int]
    r"""The organization of the requester. You can only specify the ID of an organization associated with the requester. See [Organization Memberships](/api-reference/ticketing/organizations/organization_memberships/)"""
    priority: NotRequired[TicketCreateInputPriority]
    r"""The urgency with which the ticket should be addressed."""
    problem_id: NotRequired[int]
    r"""For tickets of type \"incident\", the ID of the problem the incident is linked to"""
    requester_id: NotRequired[int]
    r"""The user who requested this ticket"""
    safe_update: NotRequired[bool]
    r"""Optional boolean. Prevents updates with outdated ticket data (`updated_stamp` property required when true)"""
    sharing_agreement_ids: NotRequired[List[int]]
    r"""An array of the numeric IDs of sharing agreements. Note that this replaces any existing agreements"""
    status: NotRequired[TicketCreateInputStatus]
    r"""The state of the ticket.

    If your account has activated custom ticket statuses, this is the ticket's
    status category. See [custom ticket statuses](#custom-ticket-statuses).

    """
    subject: NotRequired[str]
    r"""The value of the subject field for this ticket"""
    tags: NotRequired[List[str]]
    r"""The array of tags applied to this ticket"""
    type: NotRequired[TicketCreateInputType]
    r"""The type of this ticket."""
    updated_stamp: NotRequired[datetime]
    r"""Datetime of last update received from API. See the safe_update property"""
    brand_id: NotRequired[int]
    r"""Enterprise only. The id of the brand this ticket is associated with"""
    collaborators: NotRequired[List[CollaboratorObjectTypedDict]]
    r"""POST requests only. Users to add as cc's when creating a ticket. See [Setting Collaborators](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-collaborators)"""
    email_cc_ids: NotRequired[List[int]]
    r"""The ids of agents or end users currently CC'ed on the ticket. See [CCs and followers resources](https://support.zendesk.com/hc/en-us/articles/360020585233) in the Support Help Center"""
    follower_ids: NotRequired[List[int]]
    r"""The ids of agents currently following the ticket. See [CCs and followers resources](https://support.zendesk.com/hc/en-us/articles/360020585233)"""
    macro_ids: NotRequired[List[int]]
    r"""POST requests only. List of macro IDs to be recorded in the ticket audit"""
    raw_subject: NotRequired[str]
    r"""The dynamic content placeholder, if present, or the \"subject\" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)

    """
    recipient: NotRequired[str]
    r"""The original recipient e-mail address of the ticket"""
    submitter_id: NotRequired[int]
    r"""The user who submitted the ticket. The submitter always becomes the author of the first comment on the ticket"""
    ticket_form_id: NotRequired[int]
    r"""Enterprise only. The id of the ticket form to render for the ticket"""
    via_followup_source_id: NotRequired[int]
    r"""POST requests only. The id of a closed ticket when creating a follow-up ticket. See [Creating a follow-up ticket](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#creating-a-follow-up-ticket)"""


class TicketCreateInput(BaseModel):
    comment: TicketCommentObjectInput

    additional_collaborators: Optional[List[CollaboratorObject]] = None
    r"""An array of numeric IDs, emails, or objects containing name and email properties. See [Setting Collaborators](/api-reference/ticketing/tickets/tickets/#setting-collaborators). An email notification is sent to them when the ticket is updated"""

    assignee_email: Optional[str] = None
    r"""The email address of the agent to assign the ticket to"""

    assignee_id: Optional[int] = None
    r"""The agent currently assigned to the ticket"""

    attribute_value_ids: Optional[List[int]] = None
    r"""An array of the IDs of attribute values to be associated with the ticket"""

    collaborator_ids: Optional[List[int]] = None
    r"""The ids of users currently CC'ed on the ticket"""

    custom_fields: Optional[List[TicketCreateInputCustomField]] = None
    r"""Custom fields for the ticket. See [Setting custom field values](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-custom-field-values)"""

    custom_status_id: Optional[int] = None
    r"""The custom ticket status id of the ticket. See [custom ticket statuses](#custom-ticket-statuses)"""

    due_at: OptionalNullable[datetime] = UNSET
    r"""If this is a ticket of type \"task\" it has a due date.  Due date format uses [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format."""

    email_ccs: Optional[List[EmailCCObject]] = None
    r"""An array of objects that represent agent or end users email CCs to add or delete from the ticket. See [Setting email CCs](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-email-ccs)"""

    external_id: Optional[str] = None
    r"""An id you can use to link Zendesk Support tickets to local records"""

    followers: Optional[List[FollowerObject]] = None
    r"""An array of objects that represent agent followers to add or delete from the ticket. See [Setting followers](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-followers)"""

    group_id: Optional[int] = None
    r"""The group this ticket is assigned to"""

    organization_id: Optional[int] = None
    r"""The organization of the requester. You can only specify the ID of an organization associated with the requester. See [Organization Memberships](/api-reference/ticketing/organizations/organization_memberships/)"""

    priority: Optional[TicketCreateInputPriority] = None
    r"""The urgency with which the ticket should be addressed."""

    problem_id: Optional[int] = None
    r"""For tickets of type \"incident\", the ID of the problem the incident is linked to"""

    requester_id: Optional[int] = None
    r"""The user who requested this ticket"""

    safe_update: Optional[bool] = None
    r"""Optional boolean. Prevents updates with outdated ticket data (`updated_stamp` property required when true)"""

    sharing_agreement_ids: Optional[List[int]] = None
    r"""An array of the numeric IDs of sharing agreements. Note that this replaces any existing agreements"""

    status: Optional[TicketCreateInputStatus] = None
    r"""The state of the ticket.

    If your account has activated custom ticket statuses, this is the ticket's
    status category. See [custom ticket statuses](#custom-ticket-statuses).

    """

    subject: Optional[str] = None
    r"""The value of the subject field for this ticket"""

    tags: Optional[List[str]] = None
    r"""The array of tags applied to this ticket"""

    type: Optional[TicketCreateInputType] = None
    r"""The type of this ticket."""

    updated_stamp: Optional[datetime] = None
    r"""Datetime of last update received from API. See the safe_update property"""

    brand_id: Optional[int] = None
    r"""Enterprise only. The id of the brand this ticket is associated with"""

    collaborators: Optional[List[CollaboratorObject]] = None
    r"""POST requests only. Users to add as cc's when creating a ticket. See [Setting Collaborators](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-collaborators)"""

    email_cc_ids: Optional[List[int]] = None
    r"""The ids of agents or end users currently CC'ed on the ticket. See [CCs and followers resources](https://support.zendesk.com/hc/en-us/articles/360020585233) in the Support Help Center"""

    follower_ids: Optional[List[int]] = None
    r"""The ids of agents currently following the ticket. See [CCs and followers resources](https://support.zendesk.com/hc/en-us/articles/360020585233)"""

    macro_ids: Optional[List[int]] = None
    r"""POST requests only. List of macro IDs to be recorded in the ticket audit"""

    raw_subject: Optional[str] = None
    r"""The dynamic content placeholder, if present, or the \"subject\" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)

    """

    recipient: Optional[str] = None
    r"""The original recipient e-mail address of the ticket"""

    submitter_id: Optional[int] = None
    r"""The user who submitted the ticket. The submitter always becomes the author of the first comment on the ticket"""

    ticket_form_id: Optional[int] = None
    r"""Enterprise only. The id of the ticket form to render for the ticket"""

    via_followup_source_id: Optional[int] = None
    r"""POST requests only. The id of a closed ticket when creating a follow-up ticket. See [Creating a follow-up ticket](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#creating-a-follow-up-ticket)"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "additional_collaborators",
            "assignee_email",
            "assignee_id",
            "attribute_value_ids",
            "collaborator_ids",
            "custom_fields",
            "custom_status_id",
            "due_at",
            "email_ccs",
            "external_id",
            "followers",
            "group_id",
            "organization_id",
            "priority",
            "problem_id",
            "requester_id",
            "safe_update",
            "sharing_agreement_ids",
            "status",
            "subject",
            "tags",
            "type",
            "updated_stamp",
            "brand_id",
            "collaborators",
            "email_cc_ids",
            "follower_ids",
            "macro_ids",
            "raw_subject",
            "recipient",
            "submitter_id",
            "ticket_form_id",
            "via_followup_source_id",
        ]
        nullable_fields = ["due_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
