"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class TicketRelatedInformationTypedDict(TypedDict):
    followup_source_ids: NotRequired[List[str]]
    from_archive: NotRequired[bool]
    r"""Is true if the current ticket is archived"""
    incidents: NotRequired[int]
    r"""A count of related incident occurrences"""
    jira_issue_ids: NotRequired[List[str]]
    topic_id: NotRequired[Nullable[str]]
    r"""Related topic in the Web portal (deprecated feature)"""


class TicketRelatedInformation(BaseModel):
    followup_source_ids: Optional[List[str]] = None

    from_archive: Optional[bool] = None
    r"""Is true if the current ticket is archived"""

    incidents: Optional[int] = None
    r"""A count of related incident occurrences"""

    jira_issue_ids: Optional[List[str]] = None

    topic_id: OptionalNullable[str] = UNSET
    r"""Related topic in the Web portal (deprecated feature)"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "followup_source_ids",
            "from_archive",
            "incidents",
            "jira_issue_ids",
            "topic_id",
        ]
        nullable_fields = ["topic_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
