"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .collaboratorobject import CollaboratorObject, CollaboratorObjectTypedDict
from datetime import datetime
from pydantic import model_serializer
from typing import Any, Dict, List, Literal, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


TicketSkipObjectValueTypedDict = TypeAliasType(
    "TicketSkipObjectValueTypedDict", Union[str, int, bool, List[str]]
)
r"""The value of the custom field"""


TicketSkipObjectValue = TypeAliasType(
    "TicketSkipObjectValue", Union[str, int, bool, List[str]]
)
r"""The value of the custom field"""


class TicketSkipObjectCustomFieldTypedDict(TypedDict):
    id: NotRequired[int]
    r"""The id of the custom field"""
    value: NotRequired[Nullable[TicketSkipObjectValueTypedDict]]
    r"""The value of the custom field"""


class TicketSkipObjectCustomField(BaseModel):
    id: Optional[int] = None
    r"""The id of the custom field"""

    value: OptionalNullable[TicketSkipObjectValue] = UNSET
    r"""The value of the custom field"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "value"]
        nullable_fields = ["value"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


TicketSkipObjectPriority = Literal[
    "urgent",
    "high",
    "normal",
    "low",
]
r"""The urgency with which the ticket should be addressed"""


TicketSkipObjectStatus = Literal[
    "new",
    "open",
    "pending",
    "hold",
    "solved",
    "closed",
]
r"""The state of the ticket.

If your account has activated custom ticket statuses, this is the ticket's
status category. See [custom ticket statuses](#custom-ticket-statuses)

"""


TicketSkipObjectType = Literal[
    "problem",
    "incident",
    "question",
    "task",
]
r"""The type of this ticket"""


class TicketSkipObjectViaTypedDict(TypedDict):
    r"""For more information, see the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)"""

    channel: NotRequired[str]
    r"""This tells you how the ticket or event was created. Examples: \"web\", \"mobile\", \"rule\", \"system\" 

    """
    source: NotRequired[Dict[str, Any]]
    r"""For some channels a source object gives more information about how or why the ticket or event was created

    """


class TicketSkipObjectVia(BaseModel):
    r"""For more information, see the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)"""

    channel: Optional[str] = None
    r"""This tells you how the ticket or event was created. Examples: \"web\", \"mobile\", \"rule\", \"system\" 

    """

    source: Optional[Dict[str, Any]] = None
    r"""For some channels a source object gives more information about how or why the ticket or event was created

    """


class TicketSkipObjectTicketTypedDict(TypedDict):
    r"""The skipped ticket. See the [Ticket object reference](/api-reference/ticketing/tickets/tickets/#json-format)"""

    requester_id: int
    r"""The user who requested this ticket"""
    allow_attachments: NotRequired[bool]
    r"""Permission for agents to add add attachments to a comment. Defaults to true"""
    allow_channelback: NotRequired[bool]
    r"""Is false if channelback is disabled, true otherwise. Only applicable for channels framework ticket"""
    assignee_id: NotRequired[int]
    r"""The agent currently assigned to the ticket"""
    brand_id: NotRequired[int]
    r"""The id of the brand this ticket is associated with. See [Setting up multiple brands](https://support.zendesk.com/hc/en-us/articles/4408829476378)"""
    collaborator_ids: NotRequired[List[int]]
    r"""The ids of users currently CC'ed on the ticket"""
    collaborators: NotRequired[List[CollaboratorObjectTypedDict]]
    r"""POST requests only. Users to add as cc's when creating a ticket. See [Setting Collaborators](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-collaborators)"""
    created_at: NotRequired[datetime]
    r"""When this record was created"""
    custom_fields: NotRequired[List[TicketSkipObjectCustomFieldTypedDict]]
    r"""Custom fields for the ticket. See [Setting custom field values](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-custom-field-values)"""
    custom_status_id: NotRequired[int]
    r"""The custom ticket status id of the ticket. See [custom ticket statuses](#custom-ticket-statuses)"""
    description: NotRequired[str]
    r"""Read-only first comment on the ticket. When [creating a ticket](#create-ticket), use `comment` to set the description. See [Description and first comment](#description-and-first-comment)

    """
    due_at: NotRequired[Nullable[datetime]]
    r"""If this is a ticket of type \"task\" it has a due date.  Due date format uses [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format"""
    email_cc_ids: NotRequired[List[int]]
    r"""The ids of agents or end users currently CC'ed on the ticket. Ignored when [CCs and followers](https://support.zendesk.com/hc/en-us/articles/360020585233) is not enabled"""
    external_id: NotRequired[str]
    r"""An id you can use to link Zendesk Support tickets to local records"""
    follower_ids: NotRequired[List[int]]
    r"""The ids of agents currently following the ticket. Ignored when [CCs and followers](https://support.zendesk.com/hc/en-us/articles/360020585233) is not enabled"""
    followup_ids: NotRequired[List[int]]
    r"""The ids of the followups created from this ticket. Ids are only visible once the ticket is closed"""
    forum_topic_id: NotRequired[int]
    r"""The topic in the Zendesk Web portal this ticket originated from, if any. The Web portal is deprecated"""
    from_messaging_channel: NotRequired[bool]
    r"""If true, the ticket's [via type](/documentation/ticketing/reference-guides/via-object-reference/) is a messaging channel."""
    generated_timestamp: NotRequired[int]
    r"""A Unix timestamp that represents the most accurate reading of when this record was last updated. It is updated for all ticket updates, including system updates"""
    group_id: NotRequired[int]
    r"""The group this ticket is assigned to"""
    has_incidents: NotRequired[bool]
    r"""Is true if a ticket is a problem type and has one or more incidents linked to it. Otherwise, the value is false."""
    id: NotRequired[int]
    r"""Automatically assigned when the ticket is created"""
    is_public: NotRequired[bool]
    r"""Is true if any comments are public, false otherwise"""
    macro_ids: NotRequired[List[int]]
    r"""POST requests only. List of macro IDs to be recorded in the ticket audit"""
    organization_id: NotRequired[int]
    r"""The organization of the requester. You can only specify the ID of an organization associated with the requester. See [Organization Memberships](/api-reference/ticketing/organizations/organization_memberships/)"""
    priority: NotRequired[TicketSkipObjectPriority]
    r"""The urgency with which the ticket should be addressed"""
    problem_id: NotRequired[int]
    r"""For tickets of type \"incident\", the ID of the problem the incident is linked to"""
    raw_subject: NotRequired[str]
    r"""The dynamic content placeholder, if present, or the \"subject\" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)

    """
    recipient: NotRequired[str]
    r"""The original recipient e-mail address of the ticket. Notification emails for the ticket are sent from this address"""
    satisfaction_rating: NotRequired[Dict[str, Any]]
    r"""The satisfaction rating of the ticket, if it exists, or the state of satisfaction, \"offered\" or \"unoffered\". The value is null for plan types that don't support CSAT"""
    sharing_agreement_ids: NotRequired[List[int]]
    r"""The ids of the sharing agreements used for this ticket"""
    status: NotRequired[TicketSkipObjectStatus]
    r"""The state of the ticket.

    If your account has activated custom ticket statuses, this is the ticket's
    status category. See [custom ticket statuses](#custom-ticket-statuses)

    """
    subject: NotRequired[str]
    r"""The value of the subject field for this ticket. See [Subject](/api-reference/ticketing/tickets/tickets/#subject)

    """
    submitter_id: NotRequired[int]
    r"""The user who submitted the ticket. The submitter always becomes the author of the first comment on the ticket"""
    tags: NotRequired[List[str]]
    r"""The array of tags applied to this ticket. Unless otherwise specified, the [set tag](/api-reference/ticketing/ticket-management/tags/#set-tags) behavior is used, which overwrites and replaces existing tags"""
    ticket_form_id: NotRequired[int]
    r"""Enterprise only. The id of the ticket form to render for the ticket"""
    type: NotRequired[TicketSkipObjectType]
    r"""The type of this ticket"""
    updated_at: NotRequired[datetime]
    r"""When this record last got updated. It is updated only if the update generates a [ticket event](#incremental-ticket-event-export)"""
    url: NotRequired[str]
    r"""The API url of this ticket"""
    via: NotRequired[TicketSkipObjectViaTypedDict]
    r"""For more information, see the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)"""
    via_followup_source_id: NotRequired[int]
    r"""POST requests only. The id of a closed ticket when creating a follow-up ticket. See [Creating a follow-up ticket](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#creating-a-follow-up-ticket)"""


class TicketSkipObjectTicket(BaseModel):
    r"""The skipped ticket. See the [Ticket object reference](/api-reference/ticketing/tickets/tickets/#json-format)"""

    requester_id: int
    r"""The user who requested this ticket"""

    allow_attachments: Optional[bool] = None
    r"""Permission for agents to add add attachments to a comment. Defaults to true"""

    allow_channelback: Optional[bool] = None
    r"""Is false if channelback is disabled, true otherwise. Only applicable for channels framework ticket"""

    assignee_id: Optional[int] = None
    r"""The agent currently assigned to the ticket"""

    brand_id: Optional[int] = None
    r"""The id of the brand this ticket is associated with. See [Setting up multiple brands](https://support.zendesk.com/hc/en-us/articles/4408829476378)"""

    collaborator_ids: Optional[List[int]] = None
    r"""The ids of users currently CC'ed on the ticket"""

    collaborators: Optional[List[CollaboratorObject]] = None
    r"""POST requests only. Users to add as cc's when creating a ticket. See [Setting Collaborators](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-collaborators)"""

    created_at: Optional[datetime] = None
    r"""When this record was created"""

    custom_fields: Optional[List[TicketSkipObjectCustomField]] = None
    r"""Custom fields for the ticket. See [Setting custom field values](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#setting-custom-field-values)"""

    custom_status_id: Optional[int] = None
    r"""The custom ticket status id of the ticket. See [custom ticket statuses](#custom-ticket-statuses)"""

    description: Optional[str] = None
    r"""Read-only first comment on the ticket. When [creating a ticket](#create-ticket), use `comment` to set the description. See [Description and first comment](#description-and-first-comment)

    """

    due_at: OptionalNullable[datetime] = UNSET
    r"""If this is a ticket of type \"task\" it has a due date.  Due date format uses [ISO 8601](http://en.wikipedia.org/wiki/ISO_8601) format"""

    email_cc_ids: Optional[List[int]] = None
    r"""The ids of agents or end users currently CC'ed on the ticket. Ignored when [CCs and followers](https://support.zendesk.com/hc/en-us/articles/360020585233) is not enabled"""

    external_id: Optional[str] = None
    r"""An id you can use to link Zendesk Support tickets to local records"""

    follower_ids: Optional[List[int]] = None
    r"""The ids of agents currently following the ticket. Ignored when [CCs and followers](https://support.zendesk.com/hc/en-us/articles/360020585233) is not enabled"""

    followup_ids: Optional[List[int]] = None
    r"""The ids of the followups created from this ticket. Ids are only visible once the ticket is closed"""

    forum_topic_id: Optional[int] = None
    r"""The topic in the Zendesk Web portal this ticket originated from, if any. The Web portal is deprecated"""

    from_messaging_channel: Optional[bool] = None
    r"""If true, the ticket's [via type](/documentation/ticketing/reference-guides/via-object-reference/) is a messaging channel."""

    generated_timestamp: Optional[int] = None
    r"""A Unix timestamp that represents the most accurate reading of when this record was last updated. It is updated for all ticket updates, including system updates"""

    group_id: Optional[int] = None
    r"""The group this ticket is assigned to"""

    has_incidents: Optional[bool] = None
    r"""Is true if a ticket is a problem type and has one or more incidents linked to it. Otherwise, the value is false."""

    id: Optional[int] = None
    r"""Automatically assigned when the ticket is created"""

    is_public: Optional[bool] = None
    r"""Is true if any comments are public, false otherwise"""

    macro_ids: Optional[List[int]] = None
    r"""POST requests only. List of macro IDs to be recorded in the ticket audit"""

    organization_id: Optional[int] = None
    r"""The organization of the requester. You can only specify the ID of an organization associated with the requester. See [Organization Memberships](/api-reference/ticketing/organizations/organization_memberships/)"""

    priority: Optional[TicketSkipObjectPriority] = None
    r"""The urgency with which the ticket should be addressed"""

    problem_id: Optional[int] = None
    r"""For tickets of type \"incident\", the ID of the problem the incident is linked to"""

    raw_subject: Optional[str] = None
    r"""The dynamic content placeholder, if present, or the \"subject\" value, if not. See [Dynamic Content Items](/api-reference/ticketing/ticket-management/dynamic_content/)

    """

    recipient: Optional[str] = None
    r"""The original recipient e-mail address of the ticket. Notification emails for the ticket are sent from this address"""

    satisfaction_rating: Optional[Dict[str, Any]] = None
    r"""The satisfaction rating of the ticket, if it exists, or the state of satisfaction, \"offered\" or \"unoffered\". The value is null for plan types that don't support CSAT"""

    sharing_agreement_ids: Optional[List[int]] = None
    r"""The ids of the sharing agreements used for this ticket"""

    status: Optional[TicketSkipObjectStatus] = None
    r"""The state of the ticket.

    If your account has activated custom ticket statuses, this is the ticket's
    status category. See [custom ticket statuses](#custom-ticket-statuses)

    """

    subject: Optional[str] = None
    r"""The value of the subject field for this ticket. See [Subject](/api-reference/ticketing/tickets/tickets/#subject)

    """

    submitter_id: Optional[int] = None
    r"""The user who submitted the ticket. The submitter always becomes the author of the first comment on the ticket"""

    tags: Optional[List[str]] = None
    r"""The array of tags applied to this ticket. Unless otherwise specified, the [set tag](/api-reference/ticketing/ticket-management/tags/#set-tags) behavior is used, which overwrites and replaces existing tags"""

    ticket_form_id: Optional[int] = None
    r"""Enterprise only. The id of the ticket form to render for the ticket"""

    type: Optional[TicketSkipObjectType] = None
    r"""The type of this ticket"""

    updated_at: Optional[datetime] = None
    r"""When this record last got updated. It is updated only if the update generates a [ticket event](#incremental-ticket-event-export)"""

    url: Optional[str] = None
    r"""The API url of this ticket"""

    via: Optional[TicketSkipObjectVia] = None
    r"""For more information, see the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)"""

    via_followup_source_id: Optional[int] = None
    r"""POST requests only. The id of a closed ticket when creating a follow-up ticket. See [Creating a follow-up ticket](/documentation/ticketing/managing-tickets/creating-and-updating-tickets#creating-a-follow-up-ticket)"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "allow_attachments",
            "allow_channelback",
            "assignee_id",
            "brand_id",
            "collaborator_ids",
            "collaborators",
            "created_at",
            "custom_fields",
            "custom_status_id",
            "description",
            "due_at",
            "email_cc_ids",
            "external_id",
            "follower_ids",
            "followup_ids",
            "forum_topic_id",
            "from_messaging_channel",
            "generated_timestamp",
            "group_id",
            "has_incidents",
            "id",
            "is_public",
            "macro_ids",
            "organization_id",
            "priority",
            "problem_id",
            "raw_subject",
            "recipient",
            "satisfaction_rating",
            "sharing_agreement_ids",
            "status",
            "subject",
            "submitter_id",
            "tags",
            "ticket_form_id",
            "type",
            "updated_at",
            "url",
            "via",
            "via_followup_source_id",
        ]
        nullable_fields = ["due_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TicketSkipObjectTypedDict(TypedDict):
    created_at: NotRequired[datetime]
    r"""Time the skip was created"""
    id: NotRequired[int]
    r"""Automatically assigned upon creation"""
    reason: NotRequired[str]
    r"""Reason for skipping the ticket"""
    ticket: NotRequired[TicketSkipObjectTicketTypedDict]
    r"""The skipped ticket. See the [Ticket object reference](/api-reference/ticketing/tickets/tickets/#json-format)"""
    ticket_id: NotRequired[int]
    r"""ID of the skipped ticket"""
    updated_at: NotRequired[datetime]
    r"""Time the skip was last updated"""
    user_id: NotRequired[int]
    r"""ID of the skipping agent"""


class TicketSkipObject(BaseModel):
    created_at: Optional[datetime] = None
    r"""Time the skip was created"""

    id: Optional[int] = None
    r"""Automatically assigned upon creation"""

    reason: Optional[str] = None
    r"""Reason for skipping the ticket"""

    ticket: Optional[TicketSkipObjectTicket] = None
    r"""The skipped ticket. See the [Ticket object reference](/api-reference/ticketing/tickets/tickets/#json-format)"""

    ticket_id: Optional[int] = None
    r"""ID of the skipped ticket"""

    updated_at: Optional[datetime] = None
    r"""Time the skip was last updated"""

    user_id: Optional[int] = None
    r"""ID of the skipping agent"""
