"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .triggerconditionobject import (
    TriggerConditionObject,
    TriggerConditionObjectTypedDict,
)
from pydantic import model_serializer
from typing import List
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from zendesk.utils import FieldMetadata


class TriggerConditionsObjectTypedDict(TypedDict):
    r"""An object that describes the circumstances under which the trigger performs its actions. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)"""

    all: NotRequired[Nullable[List[TriggerConditionObjectTypedDict]]]
    any: NotRequired[Nullable[List[TriggerConditionObjectTypedDict]]]


class TriggerConditionsObject(BaseModel):
    r"""An object that describes the circumstances under which the trigger performs its actions. See [Conditions reference](/documentation/ticketing/reference-guides/conditions-reference)"""

    all: Annotated[
        OptionalNullable[List[TriggerConditionObject]], FieldMetadata(query=True)
    ] = UNSET

    any: Annotated[
        OptionalNullable[List[TriggerConditionObject]], FieldMetadata(query=True)
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["all", "any"]
        nullable_fields = ["all", "any"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
