"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from typing import Mapping, Optional
from zendesk import errors, models, utils
from zendesk._hooks import HookContext
from zendesk.types import OptionalNullable, UNSET
from zendesk.utils import get_security_from_env
from zendesk.utils.unmarshal_json_response import unmarshal_json_response


class ApprovalRequests(BaseSDK):
    def create_approval_request(
        self,
        *,
        approval_workflow_instance_id: str,
        assignee_user: Optional[int] = None,
        message: Optional[str] = None,
        subject: Optional[str] = None,
        ticket_id: Optional[int] = None,
        workflow_instance_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ApprovalRequestObject:
        r"""Create an Approval Request

        Creates an approval request that is attached to a ticket. The request must include all of the following information:
        - A subject and message for the approval
        - A ticket the request should be associated with
        - A [workflow instance id](/api-reference/ticketing/approvals/approval_workflow_instances/#approval-workflow-instances) for the request
        - An assignee that will act as an approver

        #### Allowed For

        * Agents


        :param approval_workflow_instance_id: The id of the approval workflow instance
        :param assignee_user: User id of the request approver
        :param message: Details for the approval request
        :param subject: Subject for the approval request
        :param ticket_id: Ticket id to attach the approval request to
        :param workflow_instance_id: Workflow instance id for the approval request
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateApprovalRequestRequest(
            approval_workflow_instance_id=approval_workflow_instance_id,
            approval_request_create_request=models.ApprovalRequestCreateRequest(
                assignee_user=assignee_user,
                message=message,
                subject=subject,
                ticket_id=ticket_id,
                workflow_instance_id=workflow_instance_id,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/api/v2/approval_workflow_instances/{approval_workflow_instance_id}/approval_requests",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.approval_request_create_request,
                False,
                False,
                "json",
                models.ApprovalRequestCreateRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="CreateApprovalRequest",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.ApprovalRequestObject, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def create_approval_request_async(
        self,
        *,
        approval_workflow_instance_id: str,
        assignee_user: Optional[int] = None,
        message: Optional[str] = None,
        subject: Optional[str] = None,
        ticket_id: Optional[int] = None,
        workflow_instance_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ApprovalRequestObject:
        r"""Create an Approval Request

        Creates an approval request that is attached to a ticket. The request must include all of the following information:
        - A subject and message for the approval
        - A ticket the request should be associated with
        - A [workflow instance id](/api-reference/ticketing/approvals/approval_workflow_instances/#approval-workflow-instances) for the request
        - An assignee that will act as an approver

        #### Allowed For

        * Agents


        :param approval_workflow_instance_id: The id of the approval workflow instance
        :param assignee_user: User id of the request approver
        :param message: Details for the approval request
        :param subject: Subject for the approval request
        :param ticket_id: Ticket id to attach the approval request to
        :param workflow_instance_id: Workflow instance id for the approval request
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateApprovalRequestRequest(
            approval_workflow_instance_id=approval_workflow_instance_id,
            approval_request_create_request=models.ApprovalRequestCreateRequest(
                assignee_user=assignee_user,
                message=message,
                subject=subject,
                ticket_id=ticket_id,
                workflow_instance_id=workflow_instance_id,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/api/v2/approval_workflow_instances/{approval_workflow_instance_id}/approval_requests",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.approval_request_create_request,
                False,
                False,
                "json",
                models.ApprovalRequestCreateRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="CreateApprovalRequest",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.ApprovalRequestObject, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def show_approval_request(
        self,
        *,
        approval_workflow_instance_id: str,
        approval_request_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ApprovalRequestObject:
        r"""Show Approval Request

        Shows an approval request.

        #### Allowed For

        * Agents


        :param approval_workflow_instance_id: The id of the approval workflow instance
        :param approval_request_id: The id of the approval request
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ShowApprovalRequestRequest(
            approval_workflow_instance_id=approval_workflow_instance_id,
            approval_request_id=approval_request_id,
        )

        req = self._build_request(
            method="GET",
            path="/api/v2/approval_workflow_instances/{approval_workflow_instance_id}/approval_requests/{approval_request_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="ShowApprovalRequest",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ApprovalRequestObject, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def show_approval_request_async(
        self,
        *,
        approval_workflow_instance_id: str,
        approval_request_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ApprovalRequestObject:
        r"""Show Approval Request

        Shows an approval request.

        #### Allowed For

        * Agents


        :param approval_workflow_instance_id: The id of the approval workflow instance
        :param approval_request_id: The id of the approval request
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ShowApprovalRequestRequest(
            approval_workflow_instance_id=approval_workflow_instance_id,
            approval_request_id=approval_request_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/api/v2/approval_workflow_instances/{approval_workflow_instance_id}/approval_requests/{approval_request_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="ShowApprovalRequest",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ApprovalRequestObject, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def update_decision_approval_request(
        self,
        *,
        approval_workflow_instance_id: str,
        approval_request_id: str,
        notes: Optional[str] = None,
        status: Optional[models.UpdateDecisionApprovalRequestStatus] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ApprovalRequestObject:
        r"""Update Approval Request Status

        Updates the  approver's decision about an approval request.

        #### Allowed For

        * Agents


        :param approval_workflow_instance_id: The id of the approval workflow instance
        :param approval_request_id: The id of the approval request
        :param notes: Notes for the decision
        :param status: The status of the approval request
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdateDecisionApprovalRequestRequest(
            approval_workflow_instance_id=approval_workflow_instance_id,
            approval_request_id=approval_request_id,
            request_body=models.UpdateDecisionApprovalRequestRequestBody(
                notes=notes,
                status=status,
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/api/v2/approval_workflow_instances/{approval_workflow_instance_id}/approval_requests/{approval_request_id}/decision",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.UpdateDecisionApprovalRequestRequestBody,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="UpdateDecisionApprovalRequest",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ApprovalRequestObject, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def update_decision_approval_request_async(
        self,
        *,
        approval_workflow_instance_id: str,
        approval_request_id: str,
        notes: Optional[str] = None,
        status: Optional[models.UpdateDecisionApprovalRequestStatus] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ApprovalRequestObject:
        r"""Update Approval Request Status

        Updates the  approver's decision about an approval request.

        #### Allowed For

        * Agents


        :param approval_workflow_instance_id: The id of the approval workflow instance
        :param approval_request_id: The id of the approval request
        :param notes: Notes for the decision
        :param status: The status of the approval request
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdateDecisionApprovalRequestRequest(
            approval_workflow_instance_id=approval_workflow_instance_id,
            approval_request_id=approval_request_id,
            request_body=models.UpdateDecisionApprovalRequestRequestBody(
                notes=notes,
                status=status,
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/api/v2/approval_workflow_instances/{approval_workflow_instance_id}/approval_requests/{approval_request_id}/decision",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.request_body,
                False,
                False,
                "json",
                models.UpdateDecisionApprovalRequestRequestBody,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="UpdateDecisionApprovalRequest",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ApprovalRequestObject, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def search_approvals(
        self,
        *,
        approval_workflow_instance_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ApprovalRequestsSearchResponse:
        r"""Get Approvals by Approval Workflow Id

        Returns a list of approvals associated with a specific [workflow instance](/api-reference/ticketing/approvals/approval_workflow_instances/#approval-workflow-instances). Results can be filtered by approval request status.

        #### Allowed For

        * Agents


        :param approval_workflow_instance_id: The id of the approval workflow instance
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SearchApprovalsRequest(
            approval_workflow_instance_id=approval_workflow_instance_id,
        )

        req = self._build_request(
            method="POST",
            path="/api/v2/approval_workflow_instances/{approval_workflow_instance_id}/approval_requests/search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="SearchApprovals",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.ApprovalRequestsSearchResponse, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def search_approvals_async(
        self,
        *,
        approval_workflow_instance_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ApprovalRequestsSearchResponse:
        r"""Get Approvals by Approval Workflow Id

        Returns a list of approvals associated with a specific [workflow instance](/api-reference/ticketing/approvals/approval_workflow_instances/#approval-workflow-instances). Results can be filtered by approval request status.

        #### Allowed For

        * Agents


        :param approval_workflow_instance_id: The id of the approval workflow instance
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SearchApprovalsRequest(
            approval_workflow_instance_id=approval_workflow_instance_id,
        )

        req = self._build_request_async(
            method="POST",
            path="/api/v2/approval_workflow_instances/{approval_workflow_instance_id}/approval_requests/search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="SearchApprovals",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["4XX", "5XX"],
            retry_config=retry_config,
        )

        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.ApprovalRequestsSearchResponse, http_res
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)
