"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from typing import List, Optional
from zendesk.errors import ZendeskError
from zendesk.models import errorresponse as models_errorresponse
from zendesk.types import BaseModel


class ErrorResponseData(BaseModel):
    error: Optional[models_errorresponse.ErrorResponseError1] = None

    errors: Optional[List[models_errorresponse.ErrorResponseError2]] = None
    r"""Field-specific validation errors"""


@dataclass(unsafe_hash=True)
class ErrorResponse(ZendeskError):
    data: ErrorResponseData = field(hash=False)

    def __init__(
        self,
        data: ErrorResponseData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) if data.error else fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
