"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from typing import Literal, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


APIKeyAuthenticationType = Literal["api_key",]


class APIKeyAuthenticationDataTypedDict(TypedDict):
    name: str
    r"""Name of the API key parameter"""
    value: NotRequired[str]
    r"""Value of the API key"""


class APIKeyAuthenticationData(BaseModel):
    name: str
    r"""Name of the API key parameter"""

    value: Optional[str] = None
    r"""Value of the API key"""


AddPosition = Literal[
    "header",
    "query_string",
]
r"""Where to add the API key (header or query string)"""


class APIKeyAuthenticationTypedDict(TypedDict):
    r"""API key authentication configuration"""

    type: APIKeyAuthenticationType
    data: APIKeyAuthenticationDataTypedDict
    add_position: NotRequired[AddPosition]
    r"""Where to add the API key (header or query string)"""


class APIKeyAuthentication(BaseModel):
    r"""API key authentication configuration"""

    type: APIKeyAuthenticationType

    data: APIKeyAuthenticationData

    add_position: Optional[AddPosition] = "header"
    r"""Where to add the API key (header or query string)"""
