"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .auditevent import AuditEvent, AuditEventTypedDict
from .viaobject import ViaObject, ViaObjectTypedDict
from datetime import datetime
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class MetadataTypedDict(TypedDict):
    r"""Additional metadata about the audit"""


class Metadata(BaseModel):
    r"""Additional metadata about the audit"""


class AuditObjectTypedDict(TypedDict):
    author_id: NotRequired[int]
    r"""ID of the user who created the audit"""
    created_at: NotRequired[datetime]
    r"""When the audit was created"""
    events: NotRequired[List[AuditEventTypedDict]]
    r"""Array of events that occurred in this audit"""
    id: NotRequired[int]
    r"""Automatically assigned audit ID"""
    metadata: NotRequired[MetadataTypedDict]
    r"""Additional metadata about the audit"""
    ticket_id: NotRequired[int]
    r"""ID of the ticket this audit belongs to"""
    via: NotRequired[ViaObjectTypedDict]
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """


class AuditObject(BaseModel):
    author_id: Optional[int] = None
    r"""ID of the user who created the audit"""

    created_at: Optional[datetime] = None
    r"""When the audit was created"""

    events: Optional[List[AuditEvent]] = None
    r"""Array of events that occurred in this audit"""

    id: Optional[int] = None
    r"""Automatically assigned audit ID"""

    metadata: Optional[Metadata] = None
    r"""Additional metadata about the audit"""

    ticket_id: Optional[int] = None
    r"""ID of the ticket this audit belongs to"""

    via: Optional[ViaObject] = None
    r"""An object explaining how the ticket was created. See the [Via object reference](/documentation/ticketing/reference-guides/via-object-reference)

    """
