"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .attachmentobject import AttachmentObject, AttachmentObjectTypedDict
from datetime import datetime
from typing import List, Literal, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


HelpCenterState = Literal[
    "enabled",
    "disabled",
    "restricted",
]
r"""The state of the Help Center"""


class BrandObjectTypedDict(TypedDict):
    name: str
    r"""The name of the brand"""
    subdomain: str
    r"""The subdomain of the brand"""
    active: NotRequired[bool]
    r"""If the brand is set as active"""
    brand_url: NotRequired[str]
    r"""The url of the brand"""
    created_at: NotRequired[datetime]
    r"""The time the brand was created"""
    default: NotRequired[bool]
    r"""Is the brand the default brand for this account"""
    has_help_center: NotRequired[bool]
    r"""If the brand has a Help Center"""
    help_center_state: NotRequired[HelpCenterState]
    r"""The state of the Help Center"""
    host_mapping: NotRequired[str]
    r"""The hostmapping to this brand, if any. Only admins view this property."""
    id: NotRequired[int]
    r"""The ID automatically assigned when the brand is created"""
    is_deleted: NotRequired[bool]
    r"""If the brand object is deleted or not"""
    logo: NotRequired[AttachmentObjectTypedDict]
    r"""A file represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/) object"""
    signature_template: NotRequired[str]
    r"""The signature template for a brand"""
    ticket_form_ids: NotRequired[List[int]]
    r"""The ids of ticket forms that are available for use by a brand"""
    updated_at: NotRequired[datetime]
    r"""The time of the last update of the brand"""
    url: NotRequired[str]
    r"""The API url of this brand"""


class BrandObject(BaseModel):
    name: str
    r"""The name of the brand"""

    subdomain: str
    r"""The subdomain of the brand"""

    active: Optional[bool] = None
    r"""If the brand is set as active"""

    brand_url: Optional[str] = None
    r"""The url of the brand"""

    created_at: Optional[datetime] = None
    r"""The time the brand was created"""

    default: Optional[bool] = None
    r"""Is the brand the default brand for this account"""

    has_help_center: Optional[bool] = None
    r"""If the brand has a Help Center"""

    help_center_state: Optional[HelpCenterState] = None
    r"""The state of the Help Center"""

    host_mapping: Optional[str] = None
    r"""The hostmapping to this brand, if any. Only admins view this property."""

    id: Optional[int] = None
    r"""The ID automatically assigned when the brand is created"""

    is_deleted: Optional[bool] = None
    r"""If the brand object is deleted or not"""

    logo: Optional[AttachmentObject] = None
    r"""A file represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/) object"""

    signature_template: Optional[str] = None
    r"""The signature template for a brand"""

    ticket_form_ids: Optional[List[int]] = None
    r"""The ids of ticket forms that are available for use by a brand"""

    updated_at: Optional[datetime] = None
    r"""The time of the last update of the brand"""

    url: Optional[str] = None
    r"""The API url of this brand"""
