"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from pydantic import ConfigDict, model_serializer
from typing import Any, Dict, List, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class CurrentUserResponseUserForEndUserTypedDict(TypedDict):
    name: str
    r"""The name of the user"""
    created_at: NotRequired[str]
    r"""The time the user was created"""
    email: NotRequired[str]
    r"""The primary email address of this user. If the primary email address is not [verified](https://support.zendesk.com/hc/en-us/articles/4408886752410), the secondary email address is used"""
    iana_time_zone: NotRequired[str]
    r"""The time zone for the user"""
    id: NotRequired[int]
    r"""Automatically assigned when creating users"""
    locale: NotRequired[str]
    r"""The locale for this user"""
    locale_id: NotRequired[int]
    r"""The language identifier for this user"""
    organization_id: NotRequired[int]
    r"""The id of the user's organization. If the user has more than one [organization memberships](/api-reference/ticketing/organizations/organization_memberships/), the id of the user's default organization. If updating, see [Organization ID](/api-reference/ticketing/users/users/#organization-id)"""
    phone: NotRequired[str]
    r"""The primary phone number of this user. See [Phone Number](/api-reference/ticketing/users/users/#phone-number) in the Users API"""
    photo: NotRequired[Dict[str, Any]]
    r"""The user's profile picture represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/) object"""
    role: NotRequired[str]
    r"""The role of the user. Possible values: `\"end-user\"`, `\"agent\"`, `\"admin\"`"""
    shared_phone_number: NotRequired[bool]
    r"""Whether the `phone` number is shared or not. See [Phone Number](/api-reference/ticketing/users/users/#phone-number) in the Users API"""
    time_zone: NotRequired[str]
    r"""The time-zone of this user"""
    updated_at: NotRequired[str]
    r"""The time of the last update of the user"""
    url: NotRequired[str]
    r"""The API url of this user"""
    verified: NotRequired[bool]
    r"""Any of the user's identities is verified. See [User Identities](/api-reference/ticketing/users/user_identities)"""
    authenticity_token: NotRequired[str]
    r"""CSRF token required by some Zendesk APIs."""


class CurrentUserResponseUserForEndUser(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    name: str
    r"""The name of the user"""

    created_at: Optional[str] = None
    r"""The time the user was created"""

    email: Optional[str] = None
    r"""The primary email address of this user. If the primary email address is not [verified](https://support.zendesk.com/hc/en-us/articles/4408886752410), the secondary email address is used"""

    iana_time_zone: Optional[str] = None
    r"""The time zone for the user"""

    id: Optional[int] = None
    r"""Automatically assigned when creating users"""

    locale: Optional[str] = None
    r"""The locale for this user"""

    locale_id: Optional[int] = None
    r"""The language identifier for this user"""

    organization_id: Optional[int] = None
    r"""The id of the user's organization. If the user has more than one [organization memberships](/api-reference/ticketing/organizations/organization_memberships/), the id of the user's default organization. If updating, see [Organization ID](/api-reference/ticketing/users/users/#organization-id)"""

    phone: Optional[str] = None
    r"""The primary phone number of this user. See [Phone Number](/api-reference/ticketing/users/users/#phone-number) in the Users API"""

    photo: Optional[Dict[str, Any]] = None
    r"""The user's profile picture represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/) object"""

    role: Optional[str] = None
    r"""The role of the user. Possible values: `\"end-user\"`, `\"agent\"`, `\"admin\"`"""

    shared_phone_number: Optional[bool] = None
    r"""Whether the `phone` number is shared or not. See [Phone Number](/api-reference/ticketing/users/users/#phone-number) in the Users API"""

    time_zone: Optional[str] = None
    r"""The time-zone of this user"""

    updated_at: Optional[str] = None
    r"""The time of the last update of the user"""

    url: Optional[str] = None
    r"""The API url of this user"""

    verified: Optional[bool] = None
    r"""Any of the user's identities is verified. See [User Identities](/api-reference/ticketing/users/user_identities)"""

    authenticity_token: Optional[str] = None
    r"""CSRF token required by some Zendesk APIs."""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class CurrentUserResponseUsersTypedDict(TypedDict):
    name: str
    r"""The user's name"""
    active: NotRequired[bool]
    r"""false if the user has been deleted"""
    alias: NotRequired[str]
    r"""An alias displayed to end users"""
    chat_only: NotRequired[bool]
    r"""Whether or not the user is a chat-only agent"""
    created_at: NotRequired[str]
    r"""The time the user was created"""
    custom_role_id: NotRequired[Nullable[int]]
    r"""A custom role if the user is an agent on the Enterprise plan or above"""
    default_group_id: NotRequired[int]
    r"""The id of the user's default group"""
    details: NotRequired[str]
    r"""Any details you want to store about the user, such as an address"""
    email: NotRequired[str]
    r"""The user's primary email address. *Writeable on create only. On update, a secondary email is added. See [Email Address](#email-address)"""
    external_id: NotRequired[Nullable[str]]
    r"""A unique identifier from another system. The API treats the id as case insensitive. Example: \"ian1\" and \"IAN1\" are the same value."""
    iana_time_zone: NotRequired[str]
    r"""The time zone for the user"""
    id: NotRequired[int]
    r"""Automatically assigned when the user is created"""
    last_login_at: NotRequired[str]
    r"""Last time the user signed in to Zendesk Support or made an API request
    using an API token or basic authentication

    """
    locale: NotRequired[str]
    r"""The user's locale. A BCP-47 compliant tag for the locale. If both \"locale\" and \"locale_id\" are present on create or update, \"locale_id\" is ignored and only \"locale\" is used."""
    locale_id: NotRequired[int]
    r"""The user's language identifier"""
    moderator: NotRequired[bool]
    r"""Designates whether the user has forum moderation capabilities"""
    notes: NotRequired[str]
    r"""Any notes you want to store about the user"""
    only_private_comments: NotRequired[bool]
    r"""true if the user can only create private comments"""
    organization_id: NotRequired[Nullable[int]]
    r"""The id of the user's organization. If the user has more than one [organization memberships](/api-reference/ticketing/organizations/organization_memberships/), the id of the user's default organization. If updating, see [Organization ID](#organization-id)"""
    phone: NotRequired[Nullable[str]]
    r"""The user's primary phone number. See [Phone Number](#phone-number) below"""
    photo: NotRequired[Nullable[Dict[str, Any]]]
    r"""The user's profile picture represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/) object"""
    remote_photo_url: NotRequired[str]
    r"""A URL pointing to the user's profile picture."""
    report_csv: NotRequired[bool]
    r"""This parameter is inert and has no effect. It may be deprecated in the
    future.

    Previously, this parameter determined whether a user could access a CSV
    report in a legacy Guide dashboard. This dashboard has been removed. See
    [Announcing Guide legacy reporting upgrade to
    Explore](https://support.zendesk.com/hc/en-us/articles/4762263171610-Announcing-Guide-legacy-reporting-upgrade-to-Explore-)

    """
    restricted_agent: NotRequired[bool]
    r"""If the agent has any restrictions; false for admins and unrestricted agents, true for other agents"""
    role: NotRequired[str]
    r"""The user's role. Possible values are \"end-user\", \"agent\", or \"admin\" """
    role_type: NotRequired[Nullable[int]]
    r"""The user's role id. 0 for a custom agent, 1 for a light agent, 2 for a chat agent, 3 for a chat agent added to the Support account as a contributor ([Chat Phase 4](https://support.zendesk.com/hc/en-us/articles/360022365373#topic_djh_1zk_4fb)), 4 for an admin, and 5 for a billing admin"""
    shared: NotRequired[bool]
    r"""If the user is shared from a different Zendesk Support instance. Ticket sharing accounts only"""
    shared_agent: NotRequired[bool]
    r"""If the user is a shared agent from a different Zendesk Support instance. Ticket sharing accounts only"""
    shared_phone_number: NotRequired[Nullable[bool]]
    r"""Whether the `phone` number is shared or not. See [Phone Number](#phone-number) below"""
    signature: NotRequired[str]
    r"""The user's signature. Only agents and admins can have signatures"""
    suspended: NotRequired[bool]
    r"""If the agent is suspended. Tickets from suspended users are also suspended, and these users cannot sign in to the end user portal"""
    tags: NotRequired[List[str]]
    r"""The user's tags. Only present if your account has user tagging enabled"""
    ticket_restriction: NotRequired[Nullable[str]]
    r"""Specifies which tickets the user has access to. Possible values are: \"organization\", \"groups\", \"assigned\", \"requested\", null. \"groups\" and \"assigned\" are valid only for agents. If you pass an invalid value to an end user (for example, \"groups\"), they will be assigned to \"requested\", regardless of their previous access"""
    time_zone: NotRequired[str]
    r"""The user's time zone. See [Time Zone](#time-zone)"""
    two_factor_auth_enabled: NotRequired[Nullable[bool]]
    r"""If two factor authentication is enabled"""
    updated_at: NotRequired[str]
    r"""The time the user was last updated"""
    url: NotRequired[str]
    r"""The user's API url"""
    user_fields: NotRequired[Dict[str, Any]]
    r"""Values of custom fields in the user's profile. See [User Fields](#user-fields)"""
    verified: NotRequired[bool]
    r"""Any of the user's identities is verified. See [User Identities](/api-reference/ticketing/users/user_identities)"""
    authenticity_token: NotRequired[str]
    r"""CSRF token required by some Zendesk APIs."""


class CurrentUserResponseUsers(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    name: str
    r"""The user's name"""

    active: Optional[bool] = None
    r"""false if the user has been deleted"""

    alias: Optional[str] = None
    r"""An alias displayed to end users"""

    chat_only: Optional[bool] = None
    r"""Whether or not the user is a chat-only agent"""

    created_at: Optional[str] = None
    r"""The time the user was created"""

    custom_role_id: OptionalNullable[int] = UNSET
    r"""A custom role if the user is an agent on the Enterprise plan or above"""

    default_group_id: Optional[int] = None
    r"""The id of the user's default group"""

    details: Optional[str] = None
    r"""Any details you want to store about the user, such as an address"""

    email: Optional[str] = None
    r"""The user's primary email address. *Writeable on create only. On update, a secondary email is added. See [Email Address](#email-address)"""

    external_id: OptionalNullable[str] = UNSET
    r"""A unique identifier from another system. The API treats the id as case insensitive. Example: \"ian1\" and \"IAN1\" are the same value."""

    iana_time_zone: Optional[str] = None
    r"""The time zone for the user"""

    id: Optional[int] = None
    r"""Automatically assigned when the user is created"""

    last_login_at: Optional[str] = None
    r"""Last time the user signed in to Zendesk Support or made an API request
    using an API token or basic authentication

    """

    locale: Optional[str] = None
    r"""The user's locale. A BCP-47 compliant tag for the locale. If both \"locale\" and \"locale_id\" are present on create or update, \"locale_id\" is ignored and only \"locale\" is used."""

    locale_id: Optional[int] = None
    r"""The user's language identifier"""

    moderator: Optional[bool] = None
    r"""Designates whether the user has forum moderation capabilities"""

    notes: Optional[str] = None
    r"""Any notes you want to store about the user"""

    only_private_comments: Optional[bool] = None
    r"""true if the user can only create private comments"""

    organization_id: OptionalNullable[int] = UNSET
    r"""The id of the user's organization. If the user has more than one [organization memberships](/api-reference/ticketing/organizations/organization_memberships/), the id of the user's default organization. If updating, see [Organization ID](#organization-id)"""

    phone: OptionalNullable[str] = UNSET
    r"""The user's primary phone number. See [Phone Number](#phone-number) below"""

    photo: OptionalNullable[Dict[str, Any]] = UNSET
    r"""The user's profile picture represented as an [Attachment](/api-reference/ticketing/tickets/ticket-attachments/) object"""

    remote_photo_url: Optional[str] = None
    r"""A URL pointing to the user's profile picture."""

    report_csv: Optional[bool] = None
    r"""This parameter is inert and has no effect. It may be deprecated in the
    future.

    Previously, this parameter determined whether a user could access a CSV
    report in a legacy Guide dashboard. This dashboard has been removed. See
    [Announcing Guide legacy reporting upgrade to
    Explore](https://support.zendesk.com/hc/en-us/articles/4762263171610-Announcing-Guide-legacy-reporting-upgrade-to-Explore-)

    """

    restricted_agent: Optional[bool] = None
    r"""If the agent has any restrictions; false for admins and unrestricted agents, true for other agents"""

    role: Optional[str] = None
    r"""The user's role. Possible values are \"end-user\", \"agent\", or \"admin\" """

    role_type: OptionalNullable[int] = UNSET
    r"""The user's role id. 0 for a custom agent, 1 for a light agent, 2 for a chat agent, 3 for a chat agent added to the Support account as a contributor ([Chat Phase 4](https://support.zendesk.com/hc/en-us/articles/360022365373#topic_djh_1zk_4fb)), 4 for an admin, and 5 for a billing admin"""

    shared: Optional[bool] = None
    r"""If the user is shared from a different Zendesk Support instance. Ticket sharing accounts only"""

    shared_agent: Optional[bool] = None
    r"""If the user is a shared agent from a different Zendesk Support instance. Ticket sharing accounts only"""

    shared_phone_number: OptionalNullable[bool] = UNSET
    r"""Whether the `phone` number is shared or not. See [Phone Number](#phone-number) below"""

    signature: Optional[str] = None
    r"""The user's signature. Only agents and admins can have signatures"""

    suspended: Optional[bool] = None
    r"""If the agent is suspended. Tickets from suspended users are also suspended, and these users cannot sign in to the end user portal"""

    tags: Optional[List[str]] = None
    r"""The user's tags. Only present if your account has user tagging enabled"""

    ticket_restriction: OptionalNullable[str] = UNSET
    r"""Specifies which tickets the user has access to. Possible values are: \"organization\", \"groups\", \"assigned\", \"requested\", null. \"groups\" and \"assigned\" are valid only for agents. If you pass an invalid value to an end user (for example, \"groups\"), they will be assigned to \"requested\", regardless of their previous access"""

    time_zone: Optional[str] = None
    r"""The user's time zone. See [Time Zone](#time-zone)"""

    two_factor_auth_enabled: OptionalNullable[bool] = UNSET
    r"""If two factor authentication is enabled"""

    updated_at: Optional[str] = None
    r"""The time the user was last updated"""

    url: Optional[str] = None
    r"""The user's API url"""

    user_fields: Optional[Dict[str, Any]] = None
    r"""Values of custom fields in the user's profile. See [User Fields](#user-fields)"""

    verified: Optional[bool] = None
    r"""Any of the user's identities is verified. See [User Identities](/api-reference/ticketing/users/user_identities)"""

    authenticity_token: Optional[str] = None
    r"""CSRF token required by some Zendesk APIs."""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "active",
            "alias",
            "chat_only",
            "created_at",
            "custom_role_id",
            "default_group_id",
            "details",
            "email",
            "external_id",
            "iana_time_zone",
            "id",
            "last_login_at",
            "locale",
            "locale_id",
            "moderator",
            "notes",
            "only_private_comments",
            "organization_id",
            "phone",
            "photo",
            "remote_photo_url",
            "report_csv",
            "restricted_agent",
            "role",
            "role_type",
            "shared",
            "shared_agent",
            "shared_phone_number",
            "signature",
            "suspended",
            "tags",
            "ticket_restriction",
            "time_zone",
            "two_factor_auth_enabled",
            "updated_at",
            "url",
            "user_fields",
            "verified",
            "authenticity_token",
        ]
        nullable_fields = [
            "custom_role_id",
            "external_id",
            "organization_id",
            "phone",
            "photo",
            "role_type",
            "shared_phone_number",
            "ticket_restriction",
            "two_factor_auth_enabled",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        for k, v in serialized.items():
            m[k] = v

        return m


CurrentUserResponseUserTypedDict = TypeAliasType(
    "CurrentUserResponseUserTypedDict",
    Union[
        CurrentUserResponseUserForEndUserTypedDict, CurrentUserResponseUsersTypedDict
    ],
)


CurrentUserResponseUser = TypeAliasType(
    "CurrentUserResponseUser",
    Union[CurrentUserResponseUserForEndUser, CurrentUserResponseUsers],
)


class CurrentUserResponseTypedDict(TypedDict):
    user: NotRequired[CurrentUserResponseUserTypedDict]


class CurrentUserResponse(BaseModel):
    user: Optional[CurrentUserResponseUser] = None
