"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, QueryParamMetadata


class ExportAuditLogsRequestTypedDict(TypedDict):
    filter_source_type: NotRequired[str]
    r"""Filter audit logs by the source type. For example, user or rule"""
    filter_source_id: NotRequired[int]
    r"""Filter audit logs by the source id. Requires `filter[source_type]` to also be set."""
    filter_actor_id: NotRequired[int]
    r"""Filter audit logs by the actor id"""
    filter_ip_address: NotRequired[str]
    r"""Filter audit logs by the ip address"""
    filter_created_at: NotRequired[str]
    r"""Filter audit logs by the time of creation. When used, you must specify `filter[created_at]` twice in your request, first with the start time and again with an end time"""
    filter_action: NotRequired[str]
    r"""Filter audit logs by the action"""


class ExportAuditLogsRequest(BaseModel):
    filter_source_type: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[source_type]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter audit logs by the source type. For example, user or rule"""

    filter_source_id: Annotated[
        Optional[int],
        pydantic.Field(alias="filter[source_id]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter audit logs by the source id. Requires `filter[source_type]` to also be set."""

    filter_actor_id: Annotated[
        Optional[int],
        pydantic.Field(alias="filter[actor_id]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter audit logs by the actor id"""

    filter_ip_address: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[ip_address]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter audit logs by the ip address"""

    filter_created_at: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[created_at]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter audit logs by the time of creation. When used, you must specify `filter[created_at]` twice in your request, first with the start time and again with an end time"""

    filter_action: Annotated[
        Optional[str],
        pydantic.Field(alias="filter[action]"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter audit logs by the action"""
