"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import pydantic
from pydantic import ConfigDict
from typing import Any, Dict, Union
from typing_extensions import TypeAliasType, TypedDict
from zendesk.types import BaseModel


class FailedResultTypedDict(TypedDict):
    action: str
    r"""The action the job attempted (`\"action\": \"update\"`)"""
    details: str
    r"""The details of the error"""
    error: str
    r"""The error message"""
    id: int
    r"""The id of the resource the job attempted to update"""
    success: bool
    r"""Whether the action was successful or not (`\"success\": true`)"""


class FailedResult(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    action: str
    r"""The action the job attempted (`\"action\": \"update\"`)"""

    details: str
    r"""The details of the error"""

    error: str
    r"""The error message"""

    id: int
    r"""The id of the resource the job attempted to update"""

    success: bool
    r"""Whether the action was successful or not (`\"success\": true`)"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class UpdateResourceResultTypedDict(TypedDict):
    action: str
    r"""the action the job attempted (`\"action\": \"update\"`)

    """
    id: int
    r"""the id of the resource the job attempted to update"""
    status: str
    r"""the status (`\"status\": \"Updated\"`)

    """
    success: bool
    r"""whether the action was successful or not (`\"success\": true`)

    """


class UpdateResourceResult(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    action: str
    r"""the action the job attempted (`\"action\": \"update\"`)

    """

    id: int
    r"""the id of the resource the job attempted to update"""

    status: str
    r"""the status (`\"status\": \"Updated\"`)

    """

    success: bool
    r"""whether the action was successful or not (`\"success\": true`)

    """

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


class CreateResourceResultTypedDict(TypedDict):
    id: int
    r"""the id of the new resource"""
    index: int
    r"""the index number of the resul"""


class CreateResourceResult(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    id: int
    r"""the id of the new resource"""

    index: int
    r"""the index number of the resul"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]


JobStatusResultObjectTypedDict = TypeAliasType(
    "JobStatusResultObjectTypedDict",
    Union[
        CreateResourceResultTypedDict,
        UpdateResourceResultTypedDict,
        FailedResultTypedDict,
    ],
)


JobStatusResultObject = TypeAliasType(
    "JobStatusResultObject",
    Union[CreateResourceResult, UpdateResourceResult, FailedResult],
)
