"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel


class QueueObjectAllTypedDict(TypedDict):
    field: NotRequired[str]
    operator: NotRequired[str]
    value: NotRequired[str]


class QueueObjectAll(BaseModel):
    field: Optional[str] = None

    operator: Optional[str] = None

    value: Optional[str] = None


class QueueObjectAnyTypedDict(TypedDict):
    field: NotRequired[str]
    operator: NotRequired[str]
    value: NotRequired[str]


class QueueObjectAny(BaseModel):
    field: Optional[str] = None

    operator: Optional[str] = None

    value: Optional[str] = None


class DefinitionTypedDict(TypedDict):
    r"""Conditions when queue could be applied"""

    all: NotRequired[List[QueueObjectAllTypedDict]]
    any: NotRequired[List[QueueObjectAnyTypedDict]]


class Definition(BaseModel):
    r"""Conditions when queue could be applied"""

    all: Optional[List[QueueObjectAll]] = None

    any: Optional[List[QueueObjectAny]] = None


class PrimaryGroupsGroupTypedDict(TypedDict):
    id: NotRequired[int]
    name: NotRequired[str]


class PrimaryGroupsGroup(BaseModel):
    id: Optional[int] = None

    name: Optional[str] = None


class PrimaryGroupsTypedDict(TypedDict):
    r"""Primary group ids linked to the queue"""

    count: NotRequired[int]
    groups: NotRequired[List[PrimaryGroupsGroupTypedDict]]


class PrimaryGroups(BaseModel):
    r"""Primary group ids linked to the queue"""

    count: Optional[int] = None

    groups: Optional[List[PrimaryGroupsGroup]] = None


class SecondaryGroupsGroupTypedDict(TypedDict):
    id: NotRequired[int]
    name: NotRequired[str]


class SecondaryGroupsGroup(BaseModel):
    id: Optional[int] = None

    name: Optional[str] = None


class SecondaryGroupsTypedDict(TypedDict):
    r"""Secondary group ids linked to the queue"""

    count: NotRequired[int]
    groups: NotRequired[List[SecondaryGroupsGroupTypedDict]]


class SecondaryGroups(BaseModel):
    r"""Secondary group ids linked to the queue"""

    count: Optional[int] = None

    groups: Optional[List[SecondaryGroupsGroup]] = None


class QueueObjectTypedDict(TypedDict):
    created_at: NotRequired[datetime]
    r"""The time the queue was created"""
    definition: NotRequired[DefinitionTypedDict]
    r"""Conditions when queue could be applied"""
    description: NotRequired[str]
    r"""The description of the queue"""
    id: NotRequired[str]
    r"""Automatically assigned when creating queue"""
    name: NotRequired[str]
    r"""The name of the queue"""
    order: NotRequired[int]
    r"""The queue-applied order"""
    primary_groups: NotRequired[PrimaryGroupsTypedDict]
    r"""Primary group ids linked to the queue"""
    priority: NotRequired[int]
    r"""The queue-applied priority"""
    secondary_groups: NotRequired[SecondaryGroupsTypedDict]
    r"""Secondary group ids linked to the queue"""
    updated_at: NotRequired[datetime]
    r"""The time of the queue's last update"""
    url: NotRequired[str]
    r"""The API URL of the queue"""


class QueueObject(BaseModel):
    created_at: Optional[datetime] = None
    r"""The time the queue was created"""

    definition: Optional[Definition] = None
    r"""Conditions when queue could be applied"""

    description: Optional[str] = None
    r"""The description of the queue"""

    id: Optional[str] = None
    r"""Automatically assigned when creating queue"""

    name: Optional[str] = None
    r"""The name of the queue"""

    order: Optional[int] = None
    r"""The queue-applied order"""

    primary_groups: Optional[PrimaryGroups] = None
    r"""Primary group ids linked to the queue"""

    priority: Optional[int] = None
    r"""The queue-applied priority"""

    secondary_groups: Optional[SecondaryGroups] = None
    r"""Secondary group ids linked to the queue"""

    updated_at: Optional[datetime] = None
    r"""The time of the queue's last update"""

    url: Optional[str] = None
    r"""The API URL of the queue"""
