"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .searchresultobject import SearchResultObject, SearchResultObjectTypedDict
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict
from zendesk.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL


class SearchExportResponseLinksTypedDict(TypedDict):
    r"""The links to the previous and next entries via the cursor ids in the metadata."""

    next: NotRequired[Nullable[str]]
    r"""The url to the next entry via the cursor."""
    prev: NotRequired[Nullable[str]]
    r"""The url to the previous entry via the cursor."""


class SearchExportResponseLinks(BaseModel):
    r"""The links to the previous and next entries via the cursor ids in the metadata."""

    next: OptionalNullable[str] = UNSET
    r"""The url to the next entry via the cursor."""

    prev: OptionalNullable[str] = UNSET
    r"""The url to the previous entry via the cursor."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["next", "prev"]
        nullable_fields = ["next", "prev"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SearchExportResponseMetaTypedDict(TypedDict):
    r"""Metadata for the export query response."""

    after_cursor: NotRequired[Nullable[str]]
    r"""The cursor id for the next object."""
    before_cursor: NotRequired[Nullable[str]]
    r"""The cursor id for the previous object."""
    has_more: NotRequired[bool]
    r"""Whether there are more items yet to be returned by the cursor."""


class SearchExportResponseMeta(BaseModel):
    r"""Metadata for the export query response."""

    after_cursor: OptionalNullable[str] = UNSET
    r"""The cursor id for the next object."""

    before_cursor: OptionalNullable[str] = UNSET
    r"""The cursor id for the previous object."""

    has_more: Optional[bool] = None
    r"""Whether there are more items yet to be returned by the cursor."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["after_cursor", "before_cursor", "has_more"]
        nullable_fields = ["after_cursor", "before_cursor"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SearchExportResponseTypedDict(TypedDict):
    facets: NotRequired[Nullable[str]]
    r"""The facets corresponding to the search query"""
    links: NotRequired[SearchExportResponseLinksTypedDict]
    r"""The links to the previous and next entries via the cursor ids in the metadata."""
    meta: NotRequired[SearchExportResponseMetaTypedDict]
    r"""Metadata for the export query response."""
    results: NotRequired[List[SearchResultObjectTypedDict]]
    r"""May consist of tickets, users, groups, or organizations, as specified by the `result_type` property in each result object"""


class SearchExportResponse(BaseModel):
    facets: OptionalNullable[str] = UNSET
    r"""The facets corresponding to the search query"""

    links: Optional[SearchExportResponseLinks] = None
    r"""The links to the previous and next entries via the cursor ids in the metadata."""

    meta: Optional[SearchExportResponseMeta] = None
    r"""Metadata for the export query response."""

    results: Optional[List[SearchResultObject]] = None
    r"""May consist of tickets, users, groups, or organizations, as specified by the `result_type` property in each result object"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["facets", "links", "meta", "results"]
        nullable_fields = ["facets"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
