"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .ticketcommentobject_input import (
    TicketCommentObjectInput,
    TicketCommentObjectInputTypedDict,
)
from datetime import datetime
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel


TicketCreateVoicemailTicketRequestPriority = Literal[
    "urgent",
    "high",
    "normal",
    "low",
]
r"""The urgency with which the ticket should be addressed."""


ViaID = Literal[
    44,
    45,
    46,
]
r"""Required for Create Ticket operation"""


class VoiceCommentTypedDict(TypedDict):
    r"""Required if creating voicemail ticket"""

    answered_by_id: NotRequired[int]
    r"""The agent who answered the call"""
    call_duration: NotRequired[int]
    r"""Duration in seconds of the call"""
    from_: NotRequired[str]
    r"""Incoming phone number"""
    location: NotRequired[str]
    r"""Location of the caller (optional)"""
    recording_url: NotRequired[str]
    r"""Incoming phone number"""
    started_at: NotRequired[datetime]
    r"""[ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) timestamp of the call starting time"""
    to: NotRequired[str]
    r"""Dialed phone number"""
    transcription_text: NotRequired[str]
    r"""Transcription of the call (optional)"""


class VoiceComment(BaseModel):
    r"""Required if creating voicemail ticket"""

    answered_by_id: Optional[int] = None
    r"""The agent who answered the call"""

    call_duration: Optional[int] = None
    r"""Duration in seconds of the call"""

    from_: Annotated[Optional[str], pydantic.Field(alias="from")] = None
    r"""Incoming phone number"""

    location: Optional[str] = None
    r"""Location of the caller (optional)"""

    recording_url: Optional[str] = None
    r"""Incoming phone number"""

    started_at: Optional[datetime] = None
    r"""[ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) timestamp of the call starting time"""

    to: Optional[str] = None
    r"""Dialed phone number"""

    transcription_text: Optional[str] = None
    r"""Transcription of the call (optional)"""


class TicketCreateVoicemailTicketRequestTicketTypedDict(TypedDict):
    r"""Ticket object that lists the values to set when the ticket is created"""

    comment: NotRequired[TicketCommentObjectInputTypedDict]
    priority: NotRequired[TicketCreateVoicemailTicketRequestPriority]
    r"""The urgency with which the ticket should be addressed."""
    via_id: NotRequired[ViaID]
    r"""Required for Create Ticket operation"""
    voice_comment: NotRequired[VoiceCommentTypedDict]
    r"""Required if creating voicemail ticket"""


class TicketCreateVoicemailTicketRequestTicket(BaseModel):
    r"""Ticket object that lists the values to set when the ticket is created"""

    comment: Optional[TicketCommentObjectInput] = None

    priority: Optional[TicketCreateVoicemailTicketRequestPriority] = None
    r"""The urgency with which the ticket should be addressed."""

    via_id: Optional[ViaID] = None
    r"""Required for Create Ticket operation"""

    voice_comment: Optional[VoiceComment] = None
    r"""Required if creating voicemail ticket"""


class TicketCreateVoicemailTicketRequestTypedDict(TypedDict):
    display_to_agent: NotRequired[int]
    r"""Optional value such as the ID of the agent that will see the newly created ticket."""
    ticket: NotRequired[TicketCreateVoicemailTicketRequestTicketTypedDict]
    r"""Ticket object that lists the values to set when the ticket is created"""


class TicketCreateVoicemailTicketRequest(BaseModel):
    display_to_agent: Optional[int] = None
    r"""Optional value such as the ID of the agent that will see the newly created ticket."""

    ticket: Optional[TicketCreateVoicemailTicketRequestTicket] = None
    r"""Ticket object that lists the values to set when the ticket is created"""
