"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import FieldMetadata, PathParamMetadata, RequestMetadata


UpdateDecisionApprovalRequestStatus = Literal[
    "approved",
    "rejected",
    "pending",
    "withdrawn",
]
r"""The status of the approval request"""


class UpdateDecisionApprovalRequestRequestBodyTypedDict(TypedDict):
    notes: NotRequired[str]
    r"""Notes for the decision"""
    status: NotRequired[UpdateDecisionApprovalRequestStatus]
    r"""The status of the approval request"""


class UpdateDecisionApprovalRequestRequestBody(BaseModel):
    notes: Optional[str] = None
    r"""Notes for the decision"""

    status: Optional[UpdateDecisionApprovalRequestStatus] = None
    r"""The status of the approval request"""


class UpdateDecisionApprovalRequestRequestTypedDict(TypedDict):
    approval_workflow_instance_id: str
    r"""The id of the approval workflow instance"""
    approval_request_id: str
    r"""The id of the approval request"""
    request_body: UpdateDecisionApprovalRequestRequestBodyTypedDict


class UpdateDecisionApprovalRequestRequest(BaseModel):
    approval_workflow_instance_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The id of the approval workflow instance"""

    approval_request_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The id of the approval request"""

    request_body: Annotated[
        UpdateDecisionApprovalRequestRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
