"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .apikeyauthentication import APIKeyAuthentication, APIKeyAuthenticationTypedDict
from .basicauthauthentication import (
    BasicAuthAuthentication,
    BasicAuthAuthenticationTypedDict,
)
from .bearertokenauthentication import (
    BearerTokenAuthentication,
    BearerTokenAuthenticationTypedDict,
)
from pydantic import Discriminator, Tag
from typing import Dict, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict
from zendesk.types import BaseModel
from zendesk.utils import get_discriminator


WebhookPatchRequestHTTPMethod = Literal[
    "GET",
    "POST",
    "PUT",
    "PATCH",
    "DELETE",
]


WebhookPatchRequestRequestFormat = Literal[
    "json",
    "xml",
    "form_encoded",
]


WebhookPatchRequestStatus = Literal[
    "active",
    "inactive",
]


WebhookPatchRequestAuthenticationTypedDict = TypeAliasType(
    "WebhookPatchRequestAuthenticationTypedDict",
    Union[
        BasicAuthAuthenticationTypedDict,
        BearerTokenAuthenticationTypedDict,
        APIKeyAuthenticationTypedDict,
    ],
)


WebhookPatchRequestAuthentication = Annotated[
    Union[
        Annotated[BasicAuthAuthentication, Tag("basic_auth")],
        Annotated[BearerTokenAuthentication, Tag("bearer_token")],
        Annotated[APIKeyAuthentication, Tag("api_key")],
    ],
    Discriminator(lambda m: get_discriminator(m, "type", "type")),
]


class WebhookPatchRequestWebhookTypedDict(TypedDict):
    r"""Partial webhook object with fields to update"""

    name: NotRequired[str]
    description: NotRequired[str]
    endpoint: NotRequired[str]
    http_method: NotRequired[WebhookPatchRequestHTTPMethod]
    request_format: NotRequired[WebhookPatchRequestRequestFormat]
    status: NotRequired[WebhookPatchRequestStatus]
    subscriptions: NotRequired[List[str]]
    authentication: NotRequired[WebhookPatchRequestAuthenticationTypedDict]
    custom_headers: NotRequired[Dict[str, str]]


class WebhookPatchRequestWebhook(BaseModel):
    r"""Partial webhook object with fields to update"""

    name: Optional[str] = None

    description: Optional[str] = None

    endpoint: Optional[str] = None

    http_method: Optional[WebhookPatchRequestHTTPMethod] = None

    request_format: Optional[WebhookPatchRequestRequestFormat] = None

    status: Optional[WebhookPatchRequestStatus] = None

    subscriptions: Optional[List[str]] = None

    authentication: Optional[WebhookPatchRequestAuthentication] = None

    custom_headers: Optional[Dict[str, str]] = None


class WebhookPatchRequestTypedDict(TypedDict):
    webhook: NotRequired[WebhookPatchRequestWebhookTypedDict]
    r"""Partial webhook object with fields to update"""


class WebhookPatchRequest(BaseModel):
    webhook: Optional[WebhookPatchRequestWebhook] = None
    r"""Partial webhook object with fields to update"""
