import httplib

# Taken from https://gist.github.com/flandr/74be22d1c3d7c1dfefdd
# Thanks, flandr.


# Python 2.6's urllib2 does not allow you to select the TLS dialect,
# and by default uses a SSLv23 compatibility negotiation implementation. 
# Besides being vulnerable to POODLE, the OSX implementation doesn't
# work correctly, failing to connect to servers that respond only to
# TLS1.0+. These classes help set up TLS support for urllib2.
import socket
import ssl
import urllib2


class TLS1Connection(httplib.HTTPSConnection):
    """Like HTTPSConnection but more specific"""
    def __init__(self, host, **kwargs):
        httplib.HTTPSConnection.__init__(self, host, **kwargs)

    def connect(self):
        """Overrides HTTPSConnection.connect to specify TLS version"""
        # Standard implementation from HTTPSConnection, which is not
        # designed for extension, unfortunately
        sock = socket.create_connection((self.host, self.port),
                                        self.timeout, self.source_address)
        if getattr(self, '_tunnel_host', None):
            self.sock = sock  # pragma: no cover
            self._tunnel()  # pragma: no cover

        # This is the only difference; default wrap_socket uses SSLv23
        self.sock = ssl.wrap_socket(sock, self.key_file, self.cert_file,
                                    ssl_version=ssl.PROTOCOL_TLSv1_2)


class TLS1Handler(urllib2.HTTPSHandler):
    """Like HTTPSHandler but more specific"""
    def __init__(self):
        urllib2.HTTPSHandler.__init__(self)

    def https_open(self, req):
        return self.do_open(TLS1Connection, req)


# Override default handler
urllib2.install_opener(urllib2.build_opener(TLS1Handler()))
