# MediaHelper

`MediaHelper` is a simple Python utility to detect media types (images, videos, audio) based on file extensions and download them into organized folders. It supports batch downloads from a file with multiple URLs, shows download progress (percentage + MB), and supports multi-threaded downloading using only Python standard libraries.

---

## Features

* Detect media type by file extension:

  * Images: `.jpeg`, `.jpg`, `.png`, `.gif`, `.bmp`, `.tiff`
  * Videos: `.mov`, `.mp4`, `.avi`, `.mkv`
  * Audio: `.mp3`, `.wav`, `.ogg`, `.flac`
  * Others: anything else
* Save downloaded files into organized folders (`images/`, `videos/`, `audio/`, `others/`).
* Show download progress with percentage and megabytes.
* Multi-threaded downloads with customizable thread count.
* CLI support for single URL or batch download from a file.

---

## Installation

No external dependencies required. Just download the `media_helper.py` script.

```bash
pip install media_helper
```

---

## Usage

### Download a single file:

```bash
python media_helper.py ~/downloads/ https://download.samplelib.com/mp3/sample-15s.mp3
```

### Download multiple files from a file:

Create `urls.txt`:

```text
https://download.samplelib.com/mp3/sample-15s.mp3
https://download.samplelib.com/mp3/sample-12s.mp3
https://github.com/my-sample-files/files-hub/raw/refs/heads/main/audio/mp3/sample-full.mp3
https://github.com/my-sample-files/files-hub/raw/refs/heads/main/audio/mp3/sample-90s.mp3
https://github.com/my-sample-files/files-hub/raw/refs/heads/main/audio/mp3/sample-60s.mp3
```

Run the download:

```bash
python media_helper.py ~/downloads/ --media-file urls.txt --threads 10
```

* `--threads` specifies the number of parallel downloads (default is 10).

### Example Output

```
Downloading sample-15s.mp3: [====================] 100.00% (0.14 MB / 0.14 MB)
Downloading sample-12s.mp3: [====================] 100.00% (0.11 MB / 0.11 MB)
Downloading sample-full.mp3: [====================] 100.00% (4.96 MB / 4.96 MB)
```

Files are saved in:

```
~/downloads/audio/sample-15s.mp3
~/downloads/audio/sample-12s.mp3
~/downloads/audio/sample-full.mp3
```

---

## Notes

* The script only detects media type by **file extension**, not by actual content.
* Works on Python 3.6+ and requires **no external packages**.
* If a file already exists with the same name, it will overwrite it (consider adding deduplication if needed).

---

