"""
    ALBOW - A Little Bit of Widgetry for PyGame
    by Gregory Ewing
    greg.ewing@canterbury.ac.nz

    Ported to Python 3 and extended by [Humberto A. Sanchez II](https://www.linkedin.com/in/hasii/)


    Usage
    -----

    The typical usage of the Albow widget system is succinctly summarized:

    1. Initialize the PyGame display surface.
    2. Create an instance of the `RootWidget`
        - Albow provides a convenience called the `Shell` widget
        - Provide it the Pygame display `surface`.
    3. Create additional widgets if needed and add them as subwidgets of the root widget. If using Shell, create
    the screens you will be using and display your main screen.
    4. Start the frame timer if you will be using it (see `RootWidget.set_timer()`).
    5. Call the `run()` method of the root widget.


    Constructors
    ------------

    There is a convention used by the constructors of Widget and its subclasses.  In addition to the arguments
    listed in the documentation for the class's constructor, a developer can also pass initial values for any
    other attributes of the class as keyword arguments.

    Developers can do this for attributes of their own Widget subclasses as well, if they provide any extra
    keyword arguments to the base class `__init__` method. The only requirement is that the attribute
    already exist as an instance or class attribute, or as a property. This ensures that mistaken
    keyword arguments are diagnosed rather than silently creating a new attribute.

    Events
    ------

    In addition to the usual PyGame event attributes, some events have extra attributes: :smile:

    | Attribute  | Event type          | Description                                                                                              |
    |------------|---------------------|----------------------------------------------------------------------------------------------------------|
    | time       | All events          | Time of occurrence of the event, in milliseconds since pygame.init() was called.                         |
    | pos        | Mouse events        | TBD                                                                                                      |
    | local      | Mouse events        | Position of the mouse in the local coordinate system of the widget to which it is delivered.             |
    | ray        | OpenGL mouse events | A pair of points representing the projection of the mouse position onto the near and far clipping planes |


    Mouse events are classified into mouse_down, mouse_drag, mouse_up and mouse_move, and are delivered by
    calling the corresponding method of the relevant widget.  Mouse-down events are delivered to the widget in
    which the event occurs.  Mouse-drag and mouse-up events are delivered to the widget that received the last
    mouse-down event.  Mouse-move events (with no mouse button pressed) are delivered to the widget in which
    they occur.

    Keyboard events are delivered by calling the key_down or key_up methods of the widget having the current
    keyboard focus.  A widget is given the keyboard focus by calling its focus() method.  If the focus widget
    does not handle a key event, it is passed up the widget hierarchy until a handler is found.

    Both mouse and keyboard events have a set of boolean attributes indicating the state of the modifier keys
    at the time of the event.

    | Attribute| State                                                        |
    | -------- | ------------------------------------------------------------ |
    | shift | True if one of the Shift keys is down.                          |
    | ctrl  | True if the Control key is down.                                |
    | alt   | True if the Alt key (Option key on Macintosh) is down.          |
    | meta  | True if the Meta key (Command key on Macintosh, Windows key     |
    |       | on PC keyboards) is down.                                       |
    | cmd   | True if either the Control or Meta key is down.  This can be    |
    |       | used to implement command keys that work according to either    |
    |       | Mac or Linux/Windows conventions.                               |


    Albow also provides timer events that are delivered to the root widget by calling its timer_event() method.
    If the developer uses the Shell and Screen classes, timer events are dispatched to the currently active `Screen`. The
    timer_event() method returns a boolean indicating whether to update the display.

"""

from albow.version import version

__pdoc__ = { 'demo': False}
