import uuid

from fastapi_users_db_sqlalchemy import GUID, SQLAlchemyBaseUserTableUUID
from pydantic import AwareDatetime
from sqlalchemy import (
    String, BIGINT, ForeignKey, DateTime
)
from sqlalchemy.orm import Mapped, mapped_column

from python3_commons.db import Base
from python3_commons.db.models.common import BaseDBModel, BaseDBUUIDModel


class UserGroup(BaseDBModel, Base):
    __tablename__ = 'user_groups'

    name: Mapped[str] = mapped_column(String, nullable=False)


class User(SQLAlchemyBaseUserTableUUID, Base):
    __tablename__ = 'users'

    username: Mapped[str] = mapped_column(String, unique=True, index=True, nullable=False)
    group_id: Mapped[int | None] = mapped_column(BIGINT, ForeignKey('user_groups.id'))
    role_id: Mapped[uuid.UUID | None] = mapped_column(
        GUID,
        ForeignKey('permissions.id', name='fk_api_key_permission_api_key', ondelete='RESTRICT'),
        nullable=False,
        index=True,
    )


class ApiKey(BaseDBUUIDModel, Base):
    __tablename__ = 'api_keys'

    user_id: Mapped[uuid.UUID | None] = mapped_column(
        GUID,
        ForeignKey('users.id', name='fk_api_key_user', ondelete='RESTRICT'),
        index=True,
    )
    partner_name: Mapped[str] = mapped_column(String, unique=True)
    key: Mapped[str] = mapped_column(String, unique=True)
    expires_at: Mapped[AwareDatetime] = mapped_column(DateTime(timezone=True))
