from cyberfusion.CoreApiClient import models

from cyberfusion.CoreApiClient._helpers import construct_includes_query_parameter
from cyberfusion.CoreApiClient.http import DtoResponse
from cyberfusion.CoreApiClient.interfaces import Resource


class Malwares(Resource):
    def list_malwares(
        self,
        *,
        page: int = 1,
        per_page: int = 50,
        include_filters: models.MalwaresSearchRequest | None = None,
        includes: list[str] | None = None,
    ) -> DtoResponse[list[models.MalwareResource]]:
        local_response = self.api_connector.send_or_fail(
            "GET",
            "/api/v1/malwares",
            data=None,
            query_parameters={
                "page": page,
                "per_page": per_page,
            }
            | (
                include_filters.model_dump(exclude_unset=True)
                if include_filters
                else {}
            )
            | construct_includes_query_parameter(includes),
        )

        return DtoResponse.from_response(local_response, models.MalwareResource)
