# -*- coding:utf-8 -*-
# this is auto-generated by swagger-marshmallow-codegen
from marshmallow import (
    Schema,
    fields,
)


class Agile(Schema):
    colorCoding = fields.Nested('User', required=True)
    columnSettings = fields.Nested('ColumnSettings', required=True)
    currentSprint = fields.Nested('Sprint', required=True)
    estimationField = fields.Nested('CustomField', required=True)
    flatBacklog = fields.Boolean(required=True)
    hideOrphansSwimlane = fields.Boolean(required=True)
    isUpdatable = fields.Boolean(required=True)
    name = fields.String(required=True)
    orphansAtTheTop = fields.Boolean(required=True)
    owner = fields.Nested('User', required=True)
    projects = fields.List(fields.String(), required=True)
    sprints = fields.List(fields.String(), required=True)
    sprintsSettings = fields.Nested('SprintsSettings', required=True)
    status = fields.Nested('AgileStatus', required=True)
    swimlaneSettings = fields.Nested('AttributeBasedSwimlaneSettings', required=True)
    updateableBy = fields.Nested('UserGroup', required=True)
    updateableByProjectBased = fields.Boolean(required=True)
    visibleFor = fields.Nested('UserGroup', required=True)
    visibleForProjectBased = fields.Boolean(required=True)
    id = fields.String(required=True)


class AgileColumn(Schema):
    fieldValues = fields.List(fields.String(), required=True)
    isResolved = fields.Boolean(required=True)
    ordinal = fields.Integer(required=True)
    parent = fields.Nested('ColumnSettings', required=True)
    presentation = fields.String(required=True)
    wipLimit = fields.Nested('WIPLimit', required=True)
    id = fields.String(required=True)


class AgileStatus(Schema):
    errors = fields.String(required=True)
    hasJobs = fields.String(required=True)
    id = fields.String(required=True)
    valid = fields.String(required=True)
    warnings = fields.String(required=True)


class AppearanceSettings(Schema):
    dateFieldFormat = fields.String(required=True)
    logo = fields.String(required=True)
    timeZone = fields.String(required=True)
    id = fields.String(required=True)


class AttributeBasedSwimlaneSettings(Schema):
    field = fields.String(required=True)
    values = fields.String(required=True)
    enabled = fields.String(required=True)
    id = fields.String(required=True)
    parent = fields.String(required=True)


class BackupError(Schema):
    date = fields.String(required=True)
    errorMessage = fields.String(required=True)
    id = fields.String(required=True)


class BackupFile(Schema):
    creationDate = fields.String(required=True)
    error = fields.String(required=True)
    id = fields.String(required=True)
    link = fields.String(required=True)
    name = fields.String(required=True)
    size = fields.String(required=True)


class BackupStatus(Schema):
    backupCancelled = fields.String(required=True)
    backupError = fields.String(required=True)
    backupInProgress = fields.String(required=True)
    stopBackup = fields.String(required=True)
    id = fields.String(required=True)


class BuildBundle(Schema):
    values = fields.String(required=True)
    id = fields.String(required=True)
    isUpdateable = fields.String(required=True)
    name = fields.String(required=True)


class BuildBundleCustomFieldDefaults(Schema):
    bundle = fields.String(required=True)
    defaultValues = fields.String(required=True)
    canBeEmpty = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    id = fields.String(required=True)
    isPublic = fields.String(required=True)
    parent = fields.String(required=True)


class BuildBundleElement(Schema):
    assembleDate = fields.String(required=True)
    bundle = fields.String(required=True)
    color = fields.String(required=True)
    description = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    id = fields.String(required=True)
    name = fields.String(required=True)
    ordinal = fields.String(required=True)


class BuildProjectCustomField(Schema):
    bundle = fields.String(required=True)
    canBeEmpty = fields.String(required=True)
    condition = fields.String(required=True)
    defaultValues = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    field = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    id = fields.String(required=True)
    isPublic = fields.String(required=True)
    ordinal = fields.String(required=True)
    project = fields.String(required=True)


class CheckResult(Schema):
    date = fields.String(required=True)
    downloadUrl = fields.String(required=True)
    id = fields.String(required=True)
    message = fields.String(required=True)
    success = fields.String(required=True)
    updateAvailable = fields.String(required=True)


class ColumnSettings(Schema):
    columns = fields.String(required=True)
    field = fields.String(required=True)
    id = fields.String(required=True)


class CommandLimitedVisibility(Schema):
    id = fields.String(required=True)
    permittedGroups = fields.String(required=True)
    permittedUsers = fields.String(required=True)


class CommandList(Schema):
    caret = fields.String(required=True)
    commands = fields.String(required=True)
    comment = fields.String(required=True)
    issues = fields.String(required=True)
    permittedGroup = fields.String(required=True)
    query = fields.String(required=True)
    runAs = fields.String(required=True)
    silent = fields.String(required=True)
    suggestions = fields.String(required=True)
    usesMarkdown = fields.String(required=True)
    visibility = fields.String(required=True)
    id = fields.String(required=True)


class CommandUnlimitedVisibility(Schema):
    id = fields.String(required=True)


class CustomField(Schema):
    aliases = fields.String(required=True)
    fieldDefaults = fields.String(required=True)
    fieldType = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    instances = fields.String(required=True)
    isAutoAttached = fields.String(required=True)
    isDisplayedInIssueList = fields.String(required=True)
    isUpdateable = fields.String(required=True)
    localizedName = fields.String(required=True)
    name = fields.String(required=True)
    ordinal = fields.String(required=True)
    id = fields.String(required=True)


class CustomFieldDefaults(Schema):
    canBeEmpty = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    isPublic = fields.String(required=True)
    parent = fields.String(required=True)
    id = fields.String(required=True)


class CustomFilterField(Schema):
    customField = fields.String(required=True)
    projects = fields.String(required=True)
    xdField = fields.String(required=True)
    aggregateable = fields.String(required=True)
    baseField = fields.String(required=True)
    id = fields.String(required=True)
    name = fields.String(required=True)
    presentation = fields.String(required=True)
    sortable = fields.String(required=True)


class DatabaseBackupSettings(Schema):
    archiveFormat = fields.String(required=True)
    availableDiskSpace = fields.String(required=True)
    backupStatus = fields.String(required=True)
    cronExpression = fields.String(required=True)
    defaultLocation = fields.String(required=True)
    filesToKeep = fields.String(required=True)
    isOn = fields.String(required=True)
    location = fields.String(required=True)
    notifiedUsers = fields.String(required=True)
    id = fields.String(required=True)


class DateFormatDescriptor(Schema):
    dateNoYearPattern = fields.String(required=True)
    datePattern = fields.String(required=True)
    id = fields.String(required=True)
    monthPattern = fields.String(required=True)
    pattern = fields.String(required=True)
    presentation = fields.String(required=True)


class DraftIssueComment(Schema):
    attachments = fields.String(required=True)
    created = fields.String(required=True)
    id = fields.String(required=True)
    text = fields.String(required=True)
    textPreview = fields.String(required=True)
    updated = fields.String(required=True)
    usesMarkdown = fields.String(required=True)
    visibility = fields.String(required=True)


class DuplicateVote(Schema):
    id = fields.String(required=True)
    issue = fields.String(required=True)
    user = fields.String(required=True)


class EmailSettings(Schema):
    from_ = fields.String(required=True, dump_to='from', load_from='from')
    host = fields.String(required=True)
    isEnabled = fields.String(required=True)
    login = fields.String(required=True)
    mailProtocol = fields.String(required=True)
    port = fields.String(required=True)
    readAccess = fields.String(required=True)
    replyTo = fields.String(required=True)
    sslKey = fields.String(required=True)
    id = fields.String(required=True)


class EnumBundle(Schema):
    values = fields.String(required=True)
    id = fields.String(required=True)
    isUpdateable = fields.String(required=True)
    name = fields.String(required=True)


class EnumBundleCustomFieldDefaults(Schema):
    bundle = fields.String(required=True)
    defaultValues = fields.String(required=True)
    canBeEmpty = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    id = fields.String(required=True)
    isPublic = fields.String(required=True)
    parent = fields.String(required=True)


class EnumBundleElement(Schema):
    bundle = fields.String(required=True)
    color = fields.String(required=True)
    description = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    id = fields.String(required=True)
    localizedName = fields.String(required=True)
    name = fields.String(required=True)
    ordinal = fields.String(required=True)


class EnumProjectCustomField(Schema):
    bundle = fields.String(required=True)
    canBeEmpty = fields.String(required=True)
    condition = fields.String(required=True)
    defaultValues = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    field = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    id = fields.String(required=True)
    isPublic = fields.String(required=True)
    ordinal = fields.String(required=True)
    project = fields.String(required=True)


class ExternalIssue(Schema):
    commentsKey = fields.String(required=True)
    commentsUrl = fields.String(required=True)
    historyKey = fields.String(required=True)
    historyUrl = fields.String(required=True)
    id = fields.String(required=True)
    key = fields.String(required=True)
    name = fields.String(required=True)
    url = fields.String(required=True)


class FieldBasedCondition(Schema):
    field = fields.String(required=True)
    showForNullValue = fields.String(required=True)
    values = fields.String(required=True)
    id = fields.String(required=True)
    parent = fields.String(required=True)


class FieldStyle(Schema):
    background = fields.String(required=True)
    foreground = fields.String(required=True)
    id = fields.String(required=True)


class GlobalSettings(Schema):
    appearanceSettings = fields.String(required=True)
    license = fields.String(required=True)
    limitations = fields.String(required=True)
    localeSettings = fields.String(required=True)
    loggingSettings = fields.String(required=True)
    notificationSettings = fields.String(required=True)
    restSettings = fields.String(required=True)
    shortcutSettings = fields.String(required=True)
    systemSettings = fields.String(required=True)
    updateInfo = fields.String(required=True)
    id = fields.String(required=True)


class GroupProjectCustomField(Schema):
    defaultValues = fields.String(required=True)
    canBeEmpty = fields.String(required=True)
    condition = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    field = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    id = fields.String(required=True)
    isPublic = fields.String(required=True)
    ordinal = fields.String(required=True)
    project = fields.String(required=True)


class Issue(Schema):
    attachments = fields.String(required=True)
    comments = fields.String(required=True)
    created = fields.String(required=True)
    description = fields.String(required=True)
    draftComment = fields.String(required=True)
    draftOwner = fields.String(required=True)
    externalIssue = fields.String(required=True)
    fields_ = fields.String(required=True, dump_to='fields', load_from='fields')
    idReadable = fields.String(required=True)
    isDraft = fields.String(required=True)
    links = fields.String(required=True)
    numberInProject = fields.String(required=True)
    parent = fields.String(required=True)
    project = fields.String(required=True)
    reporter = fields.String(required=True)
    resolved = fields.String(required=True)
    subtasks = fields.String(required=True)
    summary = fields.String(required=True)
    tags = fields.String(required=True)
    updated = fields.String(required=True)
    updater = fields.String(required=True)
    usesMarkdown = fields.String(required=True)
    visibility = fields.String(required=True)
    voters = fields.String(required=True)
    votes = fields.String(required=True)
    watchers = fields.String(required=True)
    wikifiedDescription = fields.String(required=True)
    id = fields.String(required=True)


class IssueAttachment(Schema):
    author = fields.String(required=True)
    base64Content = fields.String(required=True)
    charset = fields.String(required=True)
    comment = fields.String(required=True)
    created = fields.String(required=True)
    draft = fields.String(required=True)
    extension = fields.String(required=True)
    issue = fields.String(required=True)
    metaData = fields.String(required=True)
    mimeType = fields.String(required=True)
    name = fields.String(required=True)
    removed = fields.String(required=True)
    size = fields.String(required=True)
    thumbnailURL = fields.String(required=True)
    updated = fields.String(required=True)
    url = fields.String(required=True)
    visibility = fields.String(required=True)
    id = fields.String(required=True)


class IssueBasedSwimlaneSettings(Schema):
    defaultCardType = fields.String(required=True)
    field = fields.String(required=True)
    values = fields.String(required=True)
    enabled = fields.String(required=True)
    id = fields.String(required=True)
    parent = fields.String(required=True)


class IssueComment(Schema):
    author = fields.String(required=True)
    checkboxes = fields.String(required=True)
    deleted = fields.String(required=True)
    issue = fields.String(required=True)
    attachments = fields.String(required=True)
    created = fields.String(required=True)
    id = fields.String(required=True)
    text = fields.String(required=True)
    textPreview = fields.String(required=True)
    updated = fields.String(required=True)
    usesMarkdown = fields.String(required=True)
    visibility = fields.String(required=True)


class IssueLink(Schema):
    direction = fields.String(required=True)
    id = fields.String(required=True)
    issues = fields.String(required=True)
    linkType = fields.String(required=True)
    trimmedIssues = fields.String(required=True)


class IssueLinkType(Schema):
    aggregation = fields.String(required=True)
    directed = fields.String(required=True)
    localizedName = fields.String(required=True)
    localizedSourceToTarget = fields.String(required=True)
    localizedTargetToSource = fields.String(required=True)
    name = fields.String(required=True)
    readOnly = fields.String(required=True)
    sourceToTarget = fields.String(required=True)
    targetToSource = fields.String(required=True)
    uid = fields.String(required=True)
    id = fields.String(required=True)


class IssueTag(Schema):
    color = fields.String(required=True)
    issues = fields.String(required=True)
    owner = fields.String(required=True)
    untagOnResolve = fields.String(required=True)
    id = fields.String(required=True)
    name = fields.String(required=True)
    updateableBy = fields.String(required=True)
    visibleFor = fields.String(required=True)


class IssueVoters(Schema):
    duplicate = fields.String(required=True)
    hasVote = fields.String(required=True)
    original = fields.String(required=True)
    id = fields.String(required=True)


class IssueWatcher(Schema):
    id = fields.String(required=True)
    isStarred = fields.String(required=True)
    issue = fields.String(required=True)
    user = fields.String(required=True)


class IssueWatchers(Schema):
    duplicateWatchers = fields.String(required=True)
    hasStar = fields.String(required=True)
    id = fields.String(required=True)
    issueWatchers = fields.String(required=True)


class IssueWorkItem(Schema):
    created = fields.String(required=True)
    date = fields.String(required=True)
    duration = fields.String(required=True)
    issue = fields.String(required=True)
    updated = fields.String(required=True)
    author = fields.String(required=True)
    creator = fields.String(required=True)
    id = fields.String(required=True)
    text = fields.String(required=True)
    textPreview = fields.String(required=True)
    type = fields.String(required=True)
    usesMarkdown = fields.String(required=True)


class JabberSettings(Schema):
    host = fields.String(required=True)
    isBotEnabled = fields.String(required=True)
    isEnabled = fields.String(required=True)
    login = fields.String(required=True)
    port = fields.String(required=True)
    readAccess = fields.String(required=True)
    serviceName = fields.String(required=True)
    sslKey = fields.String(required=True)
    id = fields.String(required=True)


class License(Schema):
    enableExpirationWarning = fields.String(required=True)
    error = fields.String(required=True)
    isFreeLicenseUsed = fields.String(required=True)
    isTrialLicenseUsed = fields.String(required=True)
    license = fields.String(required=True)
    licenseCode = fields.String(required=True)
    period = fields.String(required=True)
    prepaid = fields.String(required=True)
    setupComplete = fields.String(required=True)
    username = fields.String(required=True)
    id = fields.String(required=True)


class Limitations(Schema):
    timeToExhaustDisk = fields.String(required=True)
    usableSpace = fields.String(required=True)
    id = fields.String(required=True)


class LimitedVisibility(Schema):
    implicitPermittedUsers = fields.String(required=True)
    permittedGroups = fields.String(required=True)
    permittedUsers = fields.String(required=True)
    id = fields.String(required=True)


class LocaleDescriptor(Schema):
    community = fields.String(required=True)
    id = fields.String(required=True)
    language = fields.String(required=True)
    locale = fields.String(required=True)
    name = fields.String(required=True)


class LocaleSettings(Schema):
    isRTL = fields.String(required=True)
    locale = fields.String(required=True)
    targetLocale = fields.String(required=True)
    id = fields.String(required=True)


class LoggingSettings(Schema):
    debugCategories = fields.String(required=True)
    id = fields.String(required=True)


class Logo(Schema):
    id = fields.String(required=True)
    url = fields.String(required=True)


class NotificationSettings(Schema):
    emailSettings = fields.String(required=True)
    jabberSettings = fields.String(required=True)
    restSettings = fields.String(required=True)
    id = fields.String(required=True)


class OnlineUsers(Schema):
    sessions = fields.String(required=True)
    users = fields.String(required=True)
    windows = fields.String(required=True)
    id = fields.String(required=True)


class OwnedBundle(Schema):
    values = fields.String(required=True)
    id = fields.String(required=True)
    isUpdateable = fields.String(required=True)
    name = fields.String(required=True)


class OwnedBundleCustomFieldDefaults(Schema):
    bundle = fields.String(required=True)
    defaultValues = fields.String(required=True)
    canBeEmpty = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    id = fields.String(required=True)
    isPublic = fields.String(required=True)
    parent = fields.String(required=True)


class OwnedBundleElement(Schema):
    bundle = fields.String(required=True)
    owner = fields.String(required=True)
    color = fields.String(required=True)
    description = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    id = fields.String(required=True)
    name = fields.String(required=True)
    ordinal = fields.String(required=True)


class OwnedProjectCustomField(Schema):
    bundle = fields.String(required=True)
    canBeEmpty = fields.String(required=True)
    condition = fields.String(required=True)
    defaultValues = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    field = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    id = fields.String(required=True)
    isPublic = fields.String(required=True)
    ordinal = fields.String(required=True)
    project = fields.String(required=True)


class ParsedCommand(Schema):
    delete = fields.String(required=True)
    description = fields.String(required=True)
    error = fields.String(required=True)
    id = fields.String(required=True)


class PeriodProjectCustomField(Schema):
    canBeEmpty = fields.String(required=True)
    condition = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    field = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    id = fields.String(required=True)
    isPublic = fields.String(required=True)
    ordinal = fields.String(required=True)
    project = fields.String(required=True)


class PredefinedFilterField(Schema):
    id = fields.String(required=True)
    instant = fields.String(required=True)
    presentation = fields.String(required=True)
    aggregateable = fields.String(required=True)
    baseField = fields.String(required=True)
    name = fields.String(required=True)
    sortable = fields.String(required=True)


class Project(Schema):
    archived = fields.String(required=True)
    createdBy = fields.String(required=True)
    description = fields.String(required=True)
    fields_ = fields.String(required=True, dump_to='fields', load_from='fields')
    fromEmail = fields.String(required=True)
    hubResourceId = fields.String(required=True)
    iconUrl = fields.String(required=True)
    issues = fields.String(required=True)
    leader = fields.String(required=True)
    replyToEmail = fields.String(required=True)
    ringId = fields.String(required=True)
    shortName = fields.String(required=True)
    startingNumber = fields.String(required=True)
    id = fields.String(required=True)
    name = fields.String(required=True)


class ProjectBasedColorCoding(Schema):
    projectColors = fields.String(required=True)
    agile = fields.String(required=True)
    id = fields.String(required=True)


class ProjectColor(Schema):
    color = fields.String(required=True)
    id = fields.String(required=True)
    project = fields.String(required=True)


class ProjectCustomField(Schema):
    canBeEmpty = fields.String(required=True)
    condition = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    field = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    isPublic = fields.String(required=True)
    ordinal = fields.String(required=True)
    project = fields.String(required=True)
    id = fields.String(required=True)


class ProjectTimeTrackingSettings(Schema):
    enabled = fields.String(required=True)
    estimate = fields.String(required=True)
    project = fields.String(required=True)
    timeSpent = fields.String(required=True)
    workItemTypes = fields.String(required=True)
    id = fields.String(required=True)


class RestCorsSettings(Schema):
    allowAllOrigins = fields.String(required=True)
    allowedOrigins = fields.String(required=True)
    id = fields.String(required=True)


class ShortcutSettings(Schema):
    serverShortcuts = fields.String(required=True)
    shortcuts = fields.String(required=True)
    id = fields.String(required=True)


class SimpleProjectCustomField(Schema):
    canBeEmpty = fields.String(required=True)
    condition = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    field = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    id = fields.String(required=True)
    isPublic = fields.String(required=True)
    ordinal = fields.String(required=True)
    project = fields.String(required=True)


class Sprint(Schema):
    agile = fields.String(required=True)
    archived = fields.String(required=True)
    finish = fields.String(required=True)
    goal = fields.String(required=True)
    isDefault = fields.String(required=True)
    issues = fields.String(required=True)
    name = fields.String(required=True)
    previousSprint = fields.String(required=True)
    start = fields.String(required=True)
    unresolvedIssuesCount = fields.String(required=True)
    id = fields.String(required=True)


class SprintsSettings(Schema):
    cardOnSeveralSprints = fields.String(required=True)
    defaultSprint = fields.String(required=True)
    disableSprints = fields.String(required=True)
    explicitQuery = fields.String(required=True)
    hideSubtasksOfCards = fields.String(required=True)
    isExplicit = fields.String(required=True)
    sprintSyncField = fields.String(required=True)
    id = fields.String(required=True)


class StateBundle(Schema):
    values = fields.String(required=True)
    id = fields.String(required=True)
    isUpdateable = fields.String(required=True)
    name = fields.String(required=True)


class StateBundleCustomFieldDefaults(Schema):
    bundle = fields.String(required=True)
    defaultValues = fields.String(required=True)
    canBeEmpty = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    id = fields.String(required=True)
    isPublic = fields.String(required=True)
    parent = fields.String(required=True)


class StateBundleElement(Schema):
    bundle = fields.String(required=True)
    isResolved = fields.String(required=True)
    color = fields.String(required=True)
    description = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    id = fields.String(required=True)
    localizedName = fields.String(required=True)
    name = fields.String(required=True)
    ordinal = fields.String(required=True)


class StateProjectCustomField(Schema):
    bundle = fields.String(required=True)
    canBeEmpty = fields.String(required=True)
    condition = fields.String(required=True)
    defaultValues = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    field = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    id = fields.String(required=True)
    isPublic = fields.String(required=True)
    ordinal = fields.String(required=True)
    project = fields.String(required=True)


class StorageEntry(Schema):
    name = fields.String(required=True)
    id = fields.String(required=True)


class Suggestion(Schema):
    auxiliaryIcon = fields.String(required=True)
    caret = fields.String(required=True)
    className = fields.String(required=True)
    completionEnd = fields.String(required=True)
    completionStart = fields.String(required=True)
    description = fields.String(required=True)
    group = fields.String(required=True)
    icon = fields.String(required=True)
    id = fields.String(required=True)
    matchingEnd = fields.String(required=True)
    matchingStart = fields.String(required=True)
    option = fields.String(required=True)
    prefix = fields.String(required=True)
    suffix = fields.String(required=True)


class SwimlaneEntityAttributeValue(Schema):
    isResolved = fields.String(required=True)
    name = fields.String(required=True)
    parent = fields.String(required=True)
    presentation = fields.String(required=True)
    swimlaneSettings = fields.String(required=True)
    field = fields.String(required=True)
    id = fields.String(required=True)


class SwimlaneValue(Schema):
    agileEntity = fields.String(required=True)
    id = fields.String(required=True)
    name = fields.String(required=True)
    presentation = fields.String(required=True)


class SystemSettings(Schema):
    administratorEmail = fields.String(required=True)
    allowStatisticsCollection = fields.String(required=True)
    baseUrl = fields.String(required=True)
    isApplicationReadOnly = fields.String(required=True)
    maxExportItems = fields.String(required=True)
    maxOrderedIssues = fields.String(required=True)
    maxUploadFileSize = fields.String(required=True)
    id = fields.String(required=True)


class Telemetry(Schema):
    allocatedMemory = fields.String(required=True)
    availableMemory = fields.String(required=True)
    availableProcessors = fields.String(required=True)
    blobStringsCacheHitRate = fields.String(required=True)
    cachedResultsCountInDBQueriesCache = fields.String(required=True)
    databaseBackgroundThreads = fields.String(required=True)
    databaseLocation = fields.String(required=True)
    databaseQueriesCacheHitRate = fields.String(required=True)
    databaseSize = fields.String(required=True)
    fullDatabaseSize = fields.String(required=True)
    installationFolder = fields.String(required=True)
    jobs = fields.String(required=True)
    logsLocation = fields.String(required=True)
    onlineUsers = fields.String(required=True)
    pendingAsyncJobs = fields.String(required=True)
    requestsPerSecond = fields.String(required=True)
    startedTime = fields.String(required=True)
    textIndexSize = fields.String(required=True)
    totalTransactions = fields.String(required=True)
    transactionsPerSecond = fields.String(required=True)
    uptime = fields.String(required=True)
    usedMemory = fields.String(required=True)
    id = fields.String(required=True)


class TextIndexSettings(Schema):
    documentsToIndex = fields.String(required=True)
    indexingInProgress = fields.String(required=True)
    languages = fields.String(required=True)
    suspended = fields.String(required=True)
    id = fields.String(required=True)


class TextProjectCustomField(Schema):
    canBeEmpty = fields.String(required=True)
    condition = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    field = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    id = fields.String(required=True)
    isPublic = fields.String(required=True)
    ordinal = fields.String(required=True)
    project = fields.String(required=True)


class TimeTrackingSettings(Schema):
    workItemTypes = fields.String(required=True)
    workTimeSettings = fields.String(required=True)
    id = fields.String(required=True)


class TimeZoneDescriptor(Schema):
    id = fields.String(required=True)
    offset = fields.String(required=True)
    presentation = fields.String(required=True)


class UnlimitedVisibility(Schema):
    id = fields.String(required=True)


class UpdateInfo(Schema):
    isChecking = fields.String(required=True)
    result = fields.String(required=True)
    id = fields.String(required=True)


class User(Schema):
    avatarUrl = fields.String(required=True)
    banned = fields.String(required=True)
    email = fields.String(required=True)
    fullName = fields.String(required=True)
    guest = fields.String(required=True)
    jabberAccountName = fields.String(required=True)
    login = fields.String(required=True)
    name = fields.String(required=True)
    online = fields.String(required=True)
    profiles = fields.String(required=True)
    ringId = fields.String(required=True)
    tags = fields.String(required=True)
    id = fields.String(required=True)


class UserBundle(Schema):
    aggregatedUsers = fields.String(required=True)
    groups = fields.String(required=True)
    individuals = fields.String(required=True)
    id = fields.String(required=True)
    isUpdateable = fields.String(required=True)
    name = fields.String(required=True)


class UserCustomFieldDefaults(Schema):
    bundle = fields.String(required=True)
    defaultValues = fields.String(required=True)
    canBeEmpty = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    id = fields.String(required=True)
    isPublic = fields.String(required=True)
    parent = fields.String(required=True)


class UserGroup(Schema):
    allUsersGroup = fields.String(required=True)
    icon = fields.String(required=True)
    name = fields.String(required=True)
    ringId = fields.String(required=True)
    teamForProject = fields.String(required=True)
    usersCount = fields.String(required=True)
    id = fields.String(required=True)


class UserProjectCustomField(Schema):
    bundle = fields.String(required=True)
    defaultValues = fields.String(required=True)
    canBeEmpty = fields.String(required=True)
    condition = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    field = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    id = fields.String(required=True)
    isPublic = fields.String(required=True)
    ordinal = fields.String(required=True)
    project = fields.String(required=True)


class VersionBundle(Schema):
    values = fields.String(required=True)
    id = fields.String(required=True)
    isUpdateable = fields.String(required=True)
    name = fields.String(required=True)


class VersionBundleCustomFieldDefaults(Schema):
    bundle = fields.String(required=True)
    defaultValues = fields.String(required=True)
    canBeEmpty = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    id = fields.String(required=True)
    isPublic = fields.String(required=True)
    parent = fields.String(required=True)


class VersionBundleElement(Schema):
    archived = fields.String(required=True)
    bundle = fields.String(required=True)
    releaseDate = fields.String(required=True)
    released = fields.String(required=True)
    color = fields.String(required=True)
    description = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    id = fields.String(required=True)
    name = fields.String(required=True)
    ordinal = fields.String(required=True)


class VersionProjectCustomField(Schema):
    bundle = fields.String(required=True)
    canBeEmpty = fields.String(required=True)
    condition = fields.String(required=True)
    defaultValues = fields.String(required=True)
    emptyFieldText = fields.String(required=True)
    field = fields.String(required=True)
    hasRunningJob = fields.String(required=True)
    id = fields.String(required=True)
    isPublic = fields.String(required=True)
    ordinal = fields.String(required=True)
    project = fields.String(required=True)


class Visibility(Schema):
    id = fields.String(required=True)


class WIPLimit(Schema):
    column = fields.String(required=True)
    max = fields.String(required=True)
    min = fields.String(required=True)
    id = fields.String(required=True)


class WorkItemType(Schema):
    autoAttached = fields.String(required=True)
    name = fields.String(required=True)
    id = fields.String(required=True)


class WorkTimeSettings(Schema):
    daysAWeek = fields.String(required=True)
    firstDayOfWeek = fields.String(required=True)
    minutesADay = fields.String(required=True)
    workDays = fields.String(required=True)
    id = fields.String(required=True)
