#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import enum

__all__ = ["KeyCodes", "CPlusPlusKeyCodes"]


class KeyCodes(enum.Enum):
    """
    These can be used when sending events with `adb shell input keyevent`\n
    See more https://developer.android.com/reference/android/view/KeyEvent
    """

    KEYCODE_0 = 7
    KEYCODE_11 = 227
    KEYCODE_12 = 228
    KEYCODE_1 = 8
    KEYCODE_2 = 9
    KEYCODE_3 = 10
    KEYCODE_3D_MODE = 206
    KEYCODE_4 = 11
    KEYCODE_5 = 12
    KEYCODE_6 = 13
    KEYCODE_7 = 14
    KEYCODE_8 = 15
    KEYCODE_9 = 16
    KEYCODE_A = 29
    KEYCODE_ALL_APPS = 284
    KEYCODE_ALT_LEFT = 57
    KEYCODE_ALT_RIGHT = 58
    KEYCODE_APOSTROPHE = 75
    KEYCODE_APP_SWITCH = 187
    KEYCODE_ASSIST = 219
    KEYCODE_AT = 77
    KEYCODE_AVR_INPUT = 182
    KEYCODE_AVR_POWER = 181
    KEYCODE_B = 30
    KEYCODE_BACK = 4
    KEYCODE_BACKSLASH = 73
    KEYCODE_BOOKMARK = 174
    KEYCODE_BREAK = 121
    KEYCODE_BRIGHTNESS_DOWN = 220
    KEYCODE_BRIGHTNESS_UP = 221
    KEYCODE_BUTTON_10 = 197
    KEYCODE_BUTTON_11 = 198
    KEYCODE_BUTTON_12 = 199
    KEYCODE_BUTTON_13 = 200
    KEYCODE_BUTTON_14 = 201
    KEYCODE_BUTTON_15 = 202
    KEYCODE_BUTTON_16 = 203
    KEYCODE_BUTTON_1 = 188
    KEYCODE_BUTTON_2 = 189
    KEYCODE_BUTTON_3 = 190
    KEYCODE_BUTTON_4 = 191
    KEYCODE_BUTTON_5 = 192
    KEYCODE_BUTTON_6 = 193
    KEYCODE_BUTTON_7 = 194
    KEYCODE_BUTTON_8 = 195
    KEYCODE_BUTTON_9 = 196
    KEYCODE_BUTTON_A = 96
    KEYCODE_BUTTON_B = 97
    KEYCODE_BUTTON_C = 98
    KEYCODE_BUTTON_L1 = 102
    KEYCODE_BUTTON_L2 = 104
    KEYCODE_BUTTON_MODE = 110
    KEYCODE_BUTTON_R1 = 103
    KEYCODE_BUTTON_R2 = 105
    KEYCODE_BUTTON_SELECT = 109
    KEYCODE_BUTTON_START = 108
    KEYCODE_BUTTON_THUMBL = 106
    KEYCODE_BUTTON_THUMBR = 107
    KEYCODE_BUTTON_X = 99
    KEYCODE_BUTTON_Y = 100
    KEYCODE_BUTTON_Z = 101
    KEYCODE_C = 31
    KEYCODE_CALCULATOR = 210
    KEYCODE_CALENDAR = 208
    KEYCODE_CALL = 5
    KEYCODE_CAMERA = 27
    KEYCODE_CAPS_LOCK = 115
    KEYCODE_CAPTIONS = 175
    KEYCODE_CHANNEL_DOWN = 167
    KEYCODE_CHANNEL_UP = 166
    KEYCODE_CLEAR = 28
    KEYCODE_COMMA = 55
    KEYCODE_CONTACTS = 207
    KEYCODE_COPY = 278
    KEYCODE_CTRL_LEFT = 113
    KEYCODE_CTRL_RIGHT = 114
    KEYCODE_CUT = 277
    KEYCODE_D = 32
    KEYCODE_DEL = 67
    KEYCODE_DPAD_CENTER = 23
    KEYCODE_DPAD_DOWN = 20
    KEYCODE_DPAD_DOWN_LEFT = 269
    KEYCODE_DPAD_DOWN_RIGHT = 271
    KEYCODE_DPAD_LEFT = 21
    KEYCODE_DPAD_RIGHT = 22
    KEYCODE_DPAD_UP = 19
    KEYCODE_DPAD_UP_LEFT = 268
    KEYCODE_DPAD_UP_RIGHT = 270
    KEYCODE_DVR = 173
    KEYCODE_E = 33
    KEYCODE_EISU = 212
    KEYCODE_ENDCALL = 6
    KEYCODE_ENTER = 66
    KEYCODE_ENVELOPE = 65
    KEYCODE_EQUALS = 70
    KEYCODE_ESCAPE = 111
    KEYCODE_EXPLORER = 64
    KEYCODE_F10 = 140
    KEYCODE_F11 = 141
    KEYCODE_F12 = 142
    KEYCODE_F1 = 131
    KEYCODE_F2 = 132
    KEYCODE_F3 = 133
    KEYCODE_F4 = 134
    KEYCODE_F5 = 135
    KEYCODE_F6 = 136
    KEYCODE_F7 = 137
    KEYCODE_F8 = 138
    KEYCODE_F9 = 139
    KEYCODE_F = 34
    KEYCODE_FOCUS = 80
    KEYCODE_FORWARD = 125
    KEYCODE_FORWARD_DEL = 112
    KEYCODE_FUNCTION = 119
    KEYCODE_G = 35
    KEYCODE_GRAVE = 68
    KEYCODE_GUIDE = 172
    KEYCODE_H = 36
    KEYCODE_HEADSETHOOK = 79
    KEYCODE_HELP = 259
    KEYCODE_HENKAN = 214
    KEYCODE_HOME = 3
    KEYCODE_I = 37
    KEYCODE_INFO = 165
    KEYCODE_INSERT = 124
    KEYCODE_J = 38
    KEYCODE_K = 39
    KEYCODE_KANA = 218
    KEYCODE_KATAKANA_HIRAGANA = 215
    KEYCODE_L = 40
    KEYCODE_LANGUAGE_SWITCH = 204
    KEYCODE_LAST_CHANNEL = 229
    KEYCODE_LEFT_BRACKET = 71
    KEYCODE_M = 41
    KEYCODE_MANNER_MODE = 205
    KEYCODE_MEDIA_AUDIO_TRACK = 222
    KEYCODE_MEDIA_CLOSE = 128
    KEYCODE_MEDIA_EJECT = 129
    KEYCODE_MEDIA_FAST_FORWARD = 90
    KEYCODE_MEDIA_NEXT = 87
    KEYCODE_MEDIA_PAUSE = 127
    KEYCODE_MEDIA_PLAY = 126
    KEYCODE_MEDIA_PLAY_PAUSE = 85
    KEYCODE_MEDIA_PREVIOUS = 88
    KEYCODE_MEDIA_RECORD = 130
    KEYCODE_MEDIA_REWIND = 89
    KEYCODE_MEDIA_SKIP_BACKWARD = 273
    KEYCODE_MEDIA_SKIP_FORWARD = 272
    KEYCODE_MEDIA_STEP_BACKWARD = 275
    KEYCODE_MEDIA_STEP_FORWARD = 274
    KEYCODE_MEDIA_STOP = 86
    KEYCODE_MEDIA_TOP_MENU = 226
    KEYCODE_MENU = 82
    KEYCODE_META_LEFT = 117
    KEYCODE_META_RIGHT = 118
    KEYCODE_MINUS = 69
    KEYCODE_MOVE_END = 123
    KEYCODE_MOVE_HOME = 122
    KEYCODE_MUHENKAN = 213
    KEYCODE_MUSIC = 209
    KEYCODE_MUTE = 91
    KEYCODE_N = 42
    KEYCODE_NAVIGATE_IN = 262
    KEYCODE_NAVIGATE_NEXT = 261
    KEYCODE_NAVIGATE_OUT = 263
    KEYCODE_NAVIGATE_PREVIOUS = 260
    KEYCODE_NOTIFICATION = 83
    KEYCODE_NUM = 78
    KEYCODE_NUM_LOCK = 143
    KEYCODE_NUMPAD_0 = 144
    KEYCODE_NUMPAD_1 = 145
    KEYCODE_NUMPAD_2 = 146
    KEYCODE_NUMPAD_3 = 147
    KEYCODE_NUMPAD_4 = 148
    KEYCODE_NUMPAD_5 = 149
    KEYCODE_NUMPAD_6 = 150
    KEYCODE_NUMPAD_7 = 151
    KEYCODE_NUMPAD_8 = 152
    KEYCODE_NUMPAD_9 = 153
    KEYCODE_NUMPAD_ADD = 157
    KEYCODE_NUMPAD_COMMA = 159
    KEYCODE_NUMPAD_DIVIDE = 154
    KEYCODE_NUMPAD_DOT = 158
    KEYCODE_NUMPAD_ENTER = 160
    KEYCODE_NUMPAD_EQUALS = 161
    KEYCODE_NUMPAD_LEFT_PAREN = 162
    KEYCODE_NUMPAD_MULTIPLY = 155
    KEYCODE_NUMPAD_RIGHT_PAREN = 163
    KEYCODE_NUMPAD_SUBTRACT = 156
    KEYCODE_O = 43
    KEYCODE_P = 44
    KEYCODE_PAGE_DOWN = 93
    KEYCODE_PAGE_UP = 92
    KEYCODE_PAIRING = 225
    KEYCODE_PASTE = 279
    KEYCODE_PERIOD = 56
    KEYCODE_PICTSYMBOLS = 94
    KEYCODE_PLUS = 81
    KEYCODE_POUND = 18
    KEYCODE_POWER = 26
    KEYCODE_PROFILE_SWITCH = 288
    KEYCODE_PROG_BLUE = 186
    KEYCODE_PROG_GREEN = 184
    KEYCODE_PROG_RED = 183
    KEYCODE_PROG_YELLOW = 185
    KEYCODE_Q = 45
    KEYCODE_R = 46
    KEYCODE_REFRESH = 285
    KEYCODE_RIGHT_BRACKET = 72
    KEYCODE_RO = 217
    KEYCODE_S = 47
    KEYCODE_SCROLL_LOCK = 116
    KEYCODE_SEARCH = 84
    KEYCODE_SEMICOLON = 74
    KEYCODE_SETTINGS = 176
    KEYCODE_SHIFT_LEFT = 59
    KEYCODE_SHIFT_RIGHT = 60
    KEYCODE_SLASH = 76
    KEYCODE_SLEEP = 223
    KEYCODE_SOFT_LEFT = 1
    KEYCODE_SOFT_RIGHT = 2
    KEYCODE_SOFT_SLEEP = 276
    KEYCODE_SPACE = 62
    KEYCODE_STAR = 17
    KEYCODE_STB_INPUT = 180
    KEYCODE_STB_POWER = 179
    KEYCODE_STEM_1 = 265
    KEYCODE_STEM_2 = 266
    KEYCODE_STEM_3 = 267
    KEYCODE_STEM_PRIMARY = 264
    KEYCODE_SWITCH_CHARSET = 95
    KEYCODE_SYM = 63
    KEYCODE_SYSRQ = 120
    KEYCODE_SYSTEM_NAVIGATION_DOWN = 281
    KEYCODE_SYSTEM_NAVIGATION_LEFT = 282
    KEYCODE_SYSTEM_NAVIGATION_RIGHT = 283
    KEYCODE_SYSTEM_NAVIGATION_UP = 280
    KEYCODE_T = 48
    KEYCODE_TAB = 61
    KEYCODE_THUMBS_DOWN = 287
    KEYCODE_THUMBS_UP = 286
    KEYCODE_TV = 170
    KEYCODE_TV_ANTENNA_CABLE = 242
    KEYCODE_TV_AUDIO_DESCRIPTION = 252
    KEYCODE_TV_AUDIO_DESCRIPTION_MIX_DOWN = 254
    KEYCODE_TV_AUDIO_DESCRIPTION_MIX_UP = 253
    KEYCODE_TV_CONTENTS_MENU = 256
    KEYCODE_TV_DATA_SERVICE = 230
    KEYCODE_TV_INPUT = 178
    KEYCODE_TV_INPUT_COMPONENT_1 = 249
    KEYCODE_TV_INPUT_COMPONENT_2 = 250
    KEYCODE_TV_INPUT_COMPOSITE_1 = 247
    KEYCODE_TV_INPUT_COMPOSITE_2 = 248
    KEYCODE_TV_INPUT_HDMI_1 = 243
    KEYCODE_TV_INPUT_HDMI_2 = 244
    KEYCODE_TV_INPUT_HDMI_3 = 245
    KEYCODE_TV_INPUT_HDMI_4 = 246
    KEYCODE_TV_INPUT_VGA_1 = 251
    KEYCODE_TV_MEDIA_CONTEXT_MENU = 257
    KEYCODE_TV_NETWORK = 241
    KEYCODE_TV_NUMBER_ENTRY = 234
    KEYCODE_TV_POWER = 177
    KEYCODE_TV_RADIO_SERVICE = 232
    KEYCODE_TV_SATELLITE = 237
    KEYCODE_TV_SATELLITE_BS = 238
    KEYCODE_TV_SATELLITE_CS = 239
    KEYCODE_TV_SATELLITE_SERVICE = 240
    KEYCODE_TV_TELETEXT = 233
    KEYCODE_TV_TERRESTRIAL_ANALOG = 235
    KEYCODE_TV_TERRESTRIAL_DIGITAL = 236
    KEYCODE_TV_TIMER_PROGRAMMING = 258
    KEYCODE_TV_ZOOM_MODE = 255
    KEYCODE_U = 49
    KEYCODE_UNKNOWN = 0
    KEYCODE_V = 50
    KEYCODE_VOICE_ASSIST = 231
    KEYCODE_VOLUME_DOWN = 25
    KEYCODE_VOLUME_MUTE = 164
    KEYCODE_VOLUME_UP = 24
    KEYCODE_W = 51
    KEYCODE_WAKEUP = 224
    KEYCODE_WINDOW = 171
    KEYCODE_X = 52
    KEYCODE_Y = 53
    KEYCODE_YEN = 216
    KEYCODE_Z = 54
    KEYCODE_ZENKAKU_HANKAKU = 211
    KEYCODE_ZOOM_IN = 168
    KEYCODE_ZOOM_OUT = 169


class CPlusPlusKeyCodes(enum.Enum):
    """This can be used when sending events with `adb shell sendevent /dev/sendevent /dev/input/event3`"""

    KEY_0 = 11
    KEY_0_5 = 234
    KEY_1 = 2
    KEY_102ND = 86
    KEY_2 = 3
    KEY_2_5 = 235
    KEY_3 = 4
    KEY_4 = 5
    KEY_5 = 6
    KEY_6 = 7
    KEY_7 = 8
    KEY_8 = 9
    KEY_9 = 10
    KEY_A = 30
    KEY_AB = 0x196
    KEY_AGAIN = 129
    KEY_ALTERASE = 222
    KEY_ANGLE = 0x173
    KEY_APOSTROPHE = 40
    KEY_ARCHIVE = 0x169
    KEY_AUDIO = 0x188
    KEY_AUX = 0x186
    KEY_B = 48
    KEY_BACK = 158
    KEY_BACKSLASH = 43
    KEY_BACKSPACE = 14
    KEY_BASSBOOST = 209
    KEY_BATTERY = 236
    KEY_BLUE = 0x191
    KEY_BOOKMARKS = 156
    KEY_BREAK = 0x19B
    KEY_BRIGHTNESSDOWN = 224
    KEY_BRIGHTNESSUP = 225
    KEY_BRL_DOT1 = 0x1F1
    KEY_BRL_DOT2 = 0x1F2
    KEY_BRL_DOT3 = 0x1F3
    KEY_BRL_DOT4 = 0x1F4
    KEY_BRL_DOT5 = 0x1F5
    KEY_BRL_DOT6 = 0x1F6
    KEY_BRL_DOT7 = 0x1F7
    KEY_BRL_DOT8 = 0x1F8
    KEY_C = 46
    KEY_CALC = 140
    KEY_CALENDAR = 0x18D
    KEY_CAMERA = 212
    KEY_CANCEL = 223
    KEY_CAPSLOCK = 58
    KEY_CD = 0x17F
    KEY_CENTER = 232
    KEY_CHANNEL = 0x16B
    KEY_CHANNELDOWN = 0x193
    KEY_CHANNELUP = 0x192
    KEY_CHAT = 216
    KEY_CLEAR = 0x163
    KEY_CLOSE = 206
    KEY_CLOSECD = 160
    KEY_COFFEE = 152
    KEY_COMMA = 51
    KEY_COMPOSE = 127
    KEY_COMPUTER = 157
    KEY_CONFIG = 171
    KEY_CONNECT = 218
    KEY_COPY = 133
    KEY_CUT = 137
    KEY_CYCLEWINDOWS = 154
    KEY_D = 32
    KEY_DEL_EOL = 0x1C0
    KEY_DEL_EOS = 0x1C1
    KEY_DEL_LINE = 0x1C3
    KEY_DELETE = 111
    KEY_DELETEFILE = 146
    KEY_DIGITS = 0x19D
    KEY_DIRECTION = 153
    KEY_DIRECTORY = 0x18A
    KEY_DOCUMENTS = 235
    KEY_DOT = 52
    KEY_DOWN = 108
    KEY_DVD = 0x185
    KEY_E = 18
    KEY_EDIT = 176
    KEY_EJECTCD = 161
    KEY_EJECTCLOSECD = 162
    KEY_EMAIL = 215
    KEY_END = 107
    KEY_ENTER = 28
    KEY_EPG = 0x16D
    KEY_EQUAL = 13
    KEY_ESC = 1
    KEY_EXIT = 174
    KEY_F = 33
    KEY_F1 = 59
    KEY_F10 = 68
    KEY_F11 = 87
    KEY_F12 = 88
    KEY_F13 = 183
    KEY_F14 = 184
    KEY_F15 = 185
    KEY_F16 = 186
    KEY_F17 = 187
    KEY_F18 = 188
    KEY_F19 = 189
    KEY_F2 = 60
    KEY_F20 = 190
    KEY_F21 = 191
    KEY_F22 = 192
    KEY_F23 = 193
    KEY_F24 = 194
    KEY_F3 = 61
    KEY_F4 = 62
    KEY_F5 = 63
    KEY_F6 = 64
    KEY_F7 = 65
    KEY_F8 = 66
    KEY_F9 = 67
    KEY_FASTFORWARD = 208
    KEY_FAVORITES = 0x16C
    KEY_FILE = 144
    KEY_FINANCE = 219
    KEY_FIND = 136
    KEY_FIRST = 0x194
    KEY_FN = 0x1D0
    KEY_FN_1 = 0x1DE
    KEY_FN_2 = 0x1DF
    KEY_FN_B = 0x1E4
    KEY_FN_D = 0x1E0
    KEY_FN_E = 0x1E1
    KEY_FN_ESC = 0x1D1
    KEY_FN_F = 0x1E2
    KEY_FN_F1 = 0x1D2
    KEY_FN_F10 = 0x1DB
    KEY_FN_F11 = 0x1DC
    KEY_FN_F12 = 0x1DD
    KEY_FN_F2 = 0x1D3
    KEY_FN_F3 = 0x1D4
    KEY_FN_F4 = 0x1D5
    KEY_FN_F5 = 0x1D6
    KEY_FN_F6 = 0x1D7
    KEY_FN_F7 = 0x1D8
    KEY_FN_F8 = 0x1D9
    KEY_FN_F9 = 0x1DA
    KEY_FN_S = 0x1E3
    KEY_FORWARD = 159
    KEY_FORWARDMAIL = 233
    KEY_FRONT = 132
    KEY_G = 34
    KEY_GOTO = 0x162
    KEY_GRAVE = 41
    KEY_GREEN = 0x18F
    KEY_H = 35
    KEY_HANGEUL = 122
    KEY_HANJA = 123
    KEY_HEADSETHOOK = 233
    KEY_HELP = 138
    KEY_HENKAN = 92
    KEY_HIRAGANA = 91
    KEY_HOME = 102
    KEY_HOMEPAGE = 172
    KEY_HP = 211
    KEY_I = 23
    KEY_INFO = 0x166
    KEY_INS_LINE = 0x1C2
    KEY_INSERT = 110
    KEY_ISO = 170
    KEY_J = 36
    KEY_K = 37
    KEY_KATAKANA = 90
    KEY_KATAKANAHIRAGANA = 93
    KEY_KBDILLUMDOWN = 238
    KEY_KBDILLUMTOGGLE = 237
    KEY_KBDILLUMUP = 239
    KEY_KEYBOARD = 0x176
    KEY_KP0 = 82
    KEY_KP1 = 79
    KEY_KP2 = 80
    KEY_KP3 = 81
    KEY_KP4 = 75
    KEY_KP5 = 76
    KEY_KP6 = 77
    KEY_KP7 = 71
    KEY_KP8 = 72
    KEY_KP9 = 73
    KEY_KPASTERISK = 55
    KEY_KPCOMMA = 121
    KEY_KPDOT = 83
    KEY_KPENTER = 96
    KEY_KPEQUAL = 117
    KEY_KPJPCOMMA = 95
    KEY_KPLEFTPAREN = 179
    KEY_KPMINUS = 74
    KEY_KPPLUS = 78
    KEY_KPPLUSMINUS = 118
    KEY_KPRIGHTPAREN = 180
    KEY_KPSLASH = 98
    KEY_L = 38
    KEY_LANGUAGE = 0x170
    KEY_LAST = 0x195
    KEY_LEFT = 105
    KEY_LEFTALT = 56
    KEY_LEFTBRACE = 26
    KEY_LEFTCTRL = 29
    KEY_LEFTMETA = 125
    KEY_LEFTSHIFT = 42
    KEY_LINEFEED = 101
    KEY_LIST = 0x18B
    KEY_M = 50
    KEY_MACRO = 112
    KEY_MAIL = 155
    KEY_MEDIA = 226
    KEY_MEMO = 0x18C
    KEY_MENU = 139
    KEY_MHP = 0x16F
    KEY_MINUS = 12
    KEY_MODE = 0x175
    KEY_MOVE = 175
    KEY_MP3 = 0x187
    KEY_MSDOS = 151
    KEY_MUHENKAN = 94
    KEY_MUTE = 113
    KEY_N = 49
    KEY_NEW = 181
    KEY_NEXT = 0x197
    KEY_NEXTSONG = 163
    KEY_NUMLOCK = 69
    KEY_O = 24
    KEY_OK = 0x160
    KEY_OPEN = 134
    KEY_OPTION = 0x165
    KEY_P = 25
    KEY_PAGEDOWN = 109
    KEY_PAGEUP = 104
    KEY_PASTE = 135
    KEY_PAUSE = 119
    KEY_PAUSECD = 201
    KEY_PC = 0x178
    KEY_PHONE = 169
    KEY_PLAY = 207
    KEY_PLAYCD = 200
    KEY_PLAYER = 0x183
    KEY_PLAYPAUSE = 164
    KEY_POWER = 116
    KEY_POWER2 = 0x164
    KEY_PREVIOUS = 0x19C
    KEY_PREVIOUSSONG = 165
    KEY_PRINT = 210
    KEY_PROG1 = 148
    KEY_PROG2 = 149
    KEY_PROG3 = 202
    KEY_PROG4 = 203
    KEY_PROGRAM = 0x16A
    KEY_PROPS = 130
    KEY_PVR = 0x16E
    KEY_Q = 16
    KEY_QUESTION = 214
    KEY_R = 19
    KEY_RECORD = 167
    KEY_RED = 0x18E
    KEY_REDO = 182
    KEY_REFRESH = 173
    KEY_REPLY = 232
    KEY_RESERVED = 0
    KEY_RESTART = 0x198
    KEY_REWIND = 168
    KEY_RIGHT = 106
    KEY_RIGHTALT = 100
    KEY_RIGHTBRACE = 27
    KEY_RIGHTCTRL = 97
    KEY_RIGHTMETA = 126
    KEY_RIGHTSHIFT = 54
    KEY_RO = 89
    KEY_S = 31
    KEY_SAT = 0x17D
    KEY_SAT2 = 0x17E
    KEY_SAVE = 234
    KEY_SCREEN = 0x177
    KEY_SCROLLDOWN = 178
    KEY_SCROLLLOCK = 70
    KEY_SCROLLUP = 177
    KEY_SEARCH = 217
    KEY_SELECT = 0x161
    KEY_SEMICOLON = 39
    KEY_SEND = 231
    KEY_SENDFILE = 145
    KEY_SETUP = 141
    KEY_SHARP = 228
    KEY_SHOP = 221
    KEY_SHUFFLE = 0x19A
    KEY_SLASH = 53
    KEY_SLEEP = 142
    KEY_SLOW = 0x199
    KEY_SOFT1 = 229
    KEY_SOFT2 = 230
    KEY_SOUND = 213
    KEY_SPACE = 57
    KEY_SPORT = 220
    KEY_STAR = 227
    KEY_STOP = 128
    KEY_STOPCD = 166
    KEY_SUBTITLE = 0x172
    KEY_SUSPEND = 205
    KEY_SWITCHVIDEOMODE = 236
    KEY_SYSRQ = 99
    KEY_T = 20
    KEY_TAB = 15
    KEY_TAPE = 0x180
    KEY_TEEN = 0x19E
    KEY_TEXT = 0x184
    KEY_TIME = 0x167
    KEY_TITLE = 0x171
    KEY_TUNER = 0x182
    KEY_TV = 0x179
    KEY_TV2 = 0x17A
    KEY_TWEN = 0x19F
    KEY_U = 22
    KEY_UNDO = 131
    KEY_UNKNOWN = 240
    KEY_UP = 103
    KEY_V = 47
    KEY_VCR = 0x17B
    KEY_VCR2 = 0x17C
    KEY_VENDOR = 0x168
    KEY_VIDEO = 0x189
    KEY_VOLUMEDOWN = 114
    KEY_VOLUMEUP = 115
    KEY_W = 17
    KEY_WAKEUP = 143
    KEY_WWW = 150
    KEY_X = 45
    KEY_XFER = 147
    KEY_Y = 21
    KEY_YELLOW = 0x190
    KEY_YEN = 124
    KEY_Z = 44
    KEY_ZENKAKUHANKAKU = 85
    KEY_ZOOM = 0x174
    KEY_RADIO = 386


class Event:
    MSC_SCAN = '000c0042' # or 000c0043 for android-12