from typing import List, Optional, Type, TypeVar, Union

from typing_extensions import Literal

from pythonanywhere.api.schedule import Schedule

T = TypeVar("T", bound="Task")

class Task:
    command: Optional[str] = ...
    hour: Optional[int] = ...
    minute: Optional[int] = ...
    interval: Optional[Literal["daily", "hourly"]] = ...
    enabled: Optional[bool] = ...
    task_id: Optional[int] = ...
    can_enable: Optional[bool] = ...
    expiry: Optional[str] = ...
    extend_url: Optional[str] = ...
    logfile: Optional[str] = ...
    printable_time: Optional[str] = ...
    url: Optional[str] = ...
    user: Optional[str] = ...
    schedule: Schedule = ...
    def __init__(self) -> None: ...
    def __repr__(self) -> str: ...
    @classmethod
    def from_id(cls: Type[T], task_id: int) -> T: ...
    @classmethod
    def to_be_created(
        cls: Type[T], *, command: str, minute: int, hour: Optional[int], disabled: bool,
    ) -> T: ...
    @classmethod
    def from_api_specs(cls: Type[T], specs: dict) -> T: ...
    def create_schedule(self) -> None: ...
    def delete_schedule(self) -> None: ...
    def update_specs(self, specs: dict) -> None: ...
    def update_schedule(self, params: dict, *, porcelain: bool) -> None:
        def make_spec_str(
            key: str, old_spec: Union[str, int], new_spec: Union[str, int]
        ) -> str: ...
        def make_msg(join_with: str) -> str: ...
        ...

class TaskList:
    tasks = List[Task]
    def __init__(self) -> None: ...
