python-av
====

[![GitHub Test Status][github-tests-badge]][github-tests] \
[![Gitter Chat][gitter-badge]][gitter] [![Documentation][docs-badge]][docs] \
[![Python Package Index][pypi-badge]][pypi] [![Conda Forge][conda-badge]][conda]

**python-av is a FORK of PyAV.**
**conda-forge package currently not available**

python-av is a Pythonic binding for the [FFmpeg][ffmpeg] libraries. We aim to provide all of the power and control of the underlying library, but manage the gritty details as much as possible.

python-av is for direct and precise access to your media via containers, streams, packets, codecs, and frames. It exposes a few transformations of that data, and helps you get your data to/from other packages (e.g. Numpy and Pillow).

This power does come with some responsibility as working with media is horrendously complicated and python-av can't abstract it away or make all the best decisions for you. If the `ffmpeg` command does the job without you bending over backwards, python-av is likely going to be more of a hindrance than a help.

But where you can't work without it, python-av is a critical tool.


Installation
------------

Due to the complexity of the dependencies, python-av is not always the easiest Python package to install from source. Since release 8.0.0 binary wheels are provided on [PyPI][pypi] for Linux, Mac and Windows linked against a modern FFmpeg. You can install these wheels by running:

```bash
pip install python-av
```

If you want to use your existing FFmpeg, the source version of python-av is on [PyPI][pypi] too:

```bash
pip install python-av --no-binary av
```

Alternative installation methods
--------------------------------

Another way of installing python-av is via [conda-forge][conda-forge]:

```bash
conda install python-av -c conda-forge
```

See the [Conda install][conda-install] docs to get started with (mini)Conda.

And if you want to build from the absolute source (for development or testing):

```bash
git clone git@github.com:dot-six/python-av
cd python-av
source scripts/activate.sh <FFMPEG-VERSION>

# Either install the testing dependencies:
pip install --upgrade -r tests/requirements.txt
# or have it all, including FFmpeg, built/installed for you:
# For developers, this is recommended:
./scripts/build-deps

# If you have problem doing build-deps, read this wiki:
# http://trac.ffmpeg.org/wiki/CompilationGuide/Ubuntu
# NOTE: disable all non-server libraries, it is not needed.

# Build python-av.
make
```

---

Have fun, [read the docs][docs], [come chat with us][gitter], and good luck!



[conda-badge]: https://img.shields.io/conda/vn/conda-forge/av.svg?colorB=CCB39A
[conda]: https://anaconda.org/conda-forge/python-av
[docs-badge]: https://img.shields.io/badge/docs-on%20pyav.org-blue.svg
[docs]: http://pyav.org/docs
[gitter-badge]: https://img.shields.io/gitter/room/nwjs/nw.js.svg?logo=gitter&colorB=cc2b5e
[gitter]: https://gitter.im/PyAV-Org
[pypi-badge]: https://img.shields.io/pypi/v/python-av.svg?colorB=CCB39A
[pypi]: https://pypi.org/project/python-av

[github-tests-badge]: https://github.com/dot-six/python-av/workflows/tests/badge.svg
[github-tests]: https://github.com/dot-six/python-av/actions?workflow=tests
[github]: https://github.com/dot-six/python-av

[ffmpeg]: http://ffmpeg.org/
[conda-forge]: https://conda-forge.github.io/
[conda-install]: https://docs.conda.io/projects/conda/en/latest/user-guide/install/index.html
