# Python Basic
*An easier way to write TI-Basic!*

**Python Basic aims to simplify the process of writing code for Texas Instruments calculators.**

<a href="https://www.buymeacoffee.com/owengold" target="_blank"><img src="https://cdn.buymeacoffee.com/buttons/default-yellow.png" alt="Buy Me A Coffee" height="41" width="174"></a>

For example, consider this code written in TI-Basic:
```
Prompt A
Prompt B
A²+B²→C
Disp √(C)
```

If you wanted to write the same thing in Python Basic, it would be the following:
```python
import pythonbasic as pb
import math

def theorum():
    pb.Prompt(A)
    pb.Prompt(B)
    C = pb.power(A, 2) + pb.power(B, 2)
    pb.disp(math.sqrt(C))

pb.setup(globals(), __file__, theorum)
```

This may not seem like much of an advantage, until you consider the often confusing syntax of TI-Basic.
TI-Basic:
* Doesn't color code anything
* Doesn't intent any lines
* Can often use confusing syntax

That's what *Python Basic* is for! Python Basic is written in a standard code editor, such as Visual Studio Code. Because you're in a standard text editor, you can more easily write and understand your code, and the module will convert everything to TI-Basic and output a text file. From there, you copy and paste the TI-Basic into the [TI Connect](https://education.ti.com/en/products/computer-software/ti-connect-sw) or [TI Connect CE](https://education.ti.com/en/products/computer-software/ti-connect-ce-sw) app and send it to your calculator.

## Here's a more complex example
Let's say you want a TI-Basic program that has a main menu. From there, the user can select one of five options: add, subtract, multiply, divide, or quit. If the user selects quit, the program ends. If they select any of the other options, it will prompt the user for two numbers and then perform that operation on them, returning the result.

### Here's what that looks like in *Python Basic*:
```python
import pythonbasic as pb

def main_menu_function(option):
    if option == "Add":
        pb.Prompt(A)
        pb.Prompt(B)
        S = A + B
        pb.Disp(S)
        pb.Pause()
        pb.ClrHome()
        pb.goto_menu(main_menu)
    if option == "Subtract":
        pb.Prompt(A)
        pb.Prompt(B)
        pb.Disp(A - B)
        pb.Pause()
        pb.ClrHome()
        pb.goto_menu(main_menu)
    if option == "Multiply":
        pb.Prompt(A)
        pb.Prompt(B)
        pb.Disp(A * B)
        pb.Pause()
        pb.ClrHome()
        pb.goto_menu(main_menu)
    if option == "Divide":
        pb.Prompt(A)
        pb.Prompt(B)
        pb.Disp(A / B)
        pb.Pause()
        pb.ClrHome()
        pb.goto_menu(main_menu)
    if option == "Quit":
        pb.Stop()

main_menu = pb.Menu("Main Menu", main_menu_function, [pb.MenuOption("Add"), pb.MenuOption("Subtract"), pb.MenuOption("Multiply"), pb.MenuOption("Divide"), pb.MenuOption("Quit")])

pb.setup(globals(), __file__)
```

### And here's the translated code in TI-Basic:
```
Lbl AG
Menu("MAIN MENU","ADD",AB,"SUBTRACT",AC,"MULTIPLY",AD,"DIVIDE",AE,"QUIT",AF
Lbl AB
Prompt A
Prompt B
A+B→S
Disp S
Pause 
ClrHome
Goto AG
Stop
Lbl AC
Prompt A
Prompt B
Disp A-B
Pause 
ClrHome
Goto AG
Stop
Lbl AD
Prompt A
Prompt B
Disp A*B
Pause 
ClrHome
Goto AG
Stop
Lbl AE
Prompt A
Prompt B
Disp A/B
Pause 
ClrHome
Goto AG
Stop
Lbl AF
Stop
Stop
```

**Which looks easier to read and understand?** Definitely not the latter.

This is the point of Python Basic: *to make this often confusing language much, much more accessible.*

## Statistics Support
This one's for the fellow nerds who took a statistics class in school.

Say you want to find the probability of getting a number within a certain interval. If your distribution of numbers is normal, you can use normalcdf to find this probability. And yes, *Python Basic* supports normalcdf, too.

### In *Python Basic*:
```python
import pythonbasic as pb

def normal_probability():
    pb.ClrHome()
    pb.Disp("Lower bound?")
    pb.Prompt(L)
    pb.Disp("Upper bound?")
    pb.Prompt(U)
    pb.Disp("Mean?")
    pb.Prompt(M)
    pb.Disp("Standard deviation?")
    pb.Prompt(S)
    P = pb.normalcdf(L, U, M, S)
    pb.Disp(P)

pb.setup(globals(), __file__, normal_probability)
```

### Translation in TI-Basic:
```
ClrHome
Disp "Lower bound?"
Prompt L
Disp "Upper bound?"
Prompt U
Disp "Mean?"
Prompt M
Disp "Standard deviation?"
Prompt S
normalcdf(L,U,M,S)→P
Disp P
```
| ![The translated code running on a TI-84 Plus CE](./photos/example_three.png)
|:--:| 
| *The translated code running on a TI-84 Plus CE* |

## Last example!
Given an integer, this program will find all of its postive and negative factoring pairs. It will then display all of them in a polished page format, as shown in the image below.

This also showcases Python Basic's ability to support lists, allowing you to easily manage them within your programs.

```python
import pythonbasic as pb

factors = pb.List("FTR", "{0}")

N = 0
def get_factors():
    
    pb.Disp("Integer?")
    pb.Prompt(N)

    I = 1
    while I < pb.abs(N)/2:
        R = N/I

        if factors.contains_number(R):
            I = pb.abs(N)

        if pb.fPart(R) == 0 and pb.Not(factors.contains_number(R)):
            factors.append(R)
            factors.append(I)
            factors.append(R*-1)
            factors.append(I*-1)
        
        I += 1

    pb.ClrHome()
    factors.remove_index(1)

    M = pb.dim(factors.get_list())
    I = 1

    # P represents the "page" of factors being displayed to the user. Each page holds 32 factors, in 16 pairs of 2.
    # U represents the final page of factors. If we have 70 factors, U will be 2, as pages 0 and 1 will be filled
    # with the first 64 factors, and the remaining 6 will be on page 2.
    P = 0
    U = M/32
    if pb.fPart(U) == 0:
        U -= 1
    U = pb.floor(U)

    pb.Lbl("AA")
    pb.ClrHome()

    pb.Output(1, 1, "FACTORS OF")
    pb.Output(1, 12, N)
    pb.Output(10, 1, "ENTER TO CLOSE")
    if M > 32:
        if P != 0:
            pb.Output(1, 22, "PRV ^")
        if P != U:
            pb.Output(10, 22, "NXT v")

    if P < 0:
        P = 0
    if M < U:
        P = U
    
    I = P*32+1
    R = 2

    if M-I > 32:
        # This means more than 32 factors are still left to be displayed, so we will put 32 onto this page
        while I < P*32+32:
            # Display this page of factors
            pb.Output(R,1,"("+pb.toString(factors.get_index(I))+", "+pb.toString(factors.get_index(I+1))+")")
            I += 2

            if M-I >= 1:
                pb.Output(R,14,"("+pb.toString(factors.get_index(I))+", "+pb.toString(factors.get_index(I+1))+")")
                I += 2
                R += 1
            
        K = 0   
        while K == 0:
            Q = pb.getKey()
            if Q == 25 and P != 0:
                # 25 corresponds to the up arrow key
                P -= 1
                K = Q
                pb.goto_label("AA")
            if Q == 34 and P != U:
                # down arrow pressed
                P += 1
                K = Q
                pb.goto_label("AA")
            if Q == 105:
                # enter key pressed
                K = Q
                pb.ClrHome()
                pb.Stop()
    else:
        while I < M:
            pb.Output(R,1,"("+pb.toString(factors.get_index(I))+", "+pb.toString(factors.get_index(I+1))+")")
            I += 2

            if M - I >= 1:
                pb.Output(R,14,"("+pb.toString(factors.get_index(I))+", "+pb.toString(factors.get_index(I+1))+")")
                I += 2
                R += 1
        
        if P != 0:
            K = 0   
            while K == 0:
                Q = pb.getKey()
                if Q == 25 and P != 0:
                    # 25 corresponds to the up arrow key
                    P -= 1
                    K = Q
                    pb.goto_label("AA")
                if Q == 34 and P != U:
                    # down arrow pressed
                    P += 1
                    K = Q
                    pb.goto_label("AA")
                if Q == 105:
                    # enter key pressed
                    K = Q
                    pb.ClrHome()
                    pb.Stop()
            
        pb.Pause()
        pb.ClrHome()
        pb.Stop()

pb.setup(globals(), __file__, get_factors)
```

Say we run the program and specific -300 as our integer. Here's the list of factors returned to us.

| ![The first page of the factors for -300](./photos/example_four(1).png) | ![The second page of the factors for -300](./photos/example_four(2).png)
|:--:|:--:|
| *The first page of the factors for -300* | *The second page of the factors for -300* |
