
# PythonBasicTools

[![Star on GitHub](https://img.shields.io/github/stars/JeremieGince/PythonBasicTools.svg?style=social)](https://github.com/JeremieGince/PythonBasicTools/stargazers)
[![Python 3.6](https://img.shields.io/badge/python-3.9-blue.svg)](https://www.python.org/downloads/release/python-390/)
[![License](https://img.shields.io/badge/License-Apache_2.0-blue.svg)](LICENSE)

![Tests Workflow](https://github.com/JeremieGince/PythonBasicTools/actions/workflows/tests.yml/badge.svg)
![Dist Workflow](https://github.com/JeremieGince/PythonBasicTools/actions/workflows/build_dist.yml/badge.svg)
![Doc Workflow](https://github.com/JeremieGince/PythonBasicTools/actions/workflows/docs.yml/badge.svg)
![Publish Workflow](https://github.com/JeremieGince/PythonBasicTools/actions/workflows/publish.yml/badge.svg)


--------------------------------------------------------------------------------


# Important Links

  - Documentation at [https://jeremiegince.github.io/PythonBasicTools/](https://jeremiegince.github.io/PythonBasicTools/).
  - Github at [https://github.com/JeremieGince/PythonBasicTools/](https://github.com/JeremieGince/PythonBasicTools/).

# Description

This package is a module containing a set of tools useful to any project made with python. 
It contains tools for:

  - Logging;
  - Device setup with sklearn, pytorch and tensorflow;
  - Multiprocessing;
  - Progress bar;
  - Sending files to a discord server;
  - Useful decorators;
  - Useful functions for docstrings;
  - And more to come!

---------------------------------------------------------------------------


# Installation

## With PyPI:

```bash
pip install pythonbasictools
```

## With wheel

   1. Download the .whl file [here](https://github.com/JeremieGince/PythonBasicTools/tree/main/dist/PythonBasicTools-0.0.0.1-py3-none-any.whl);
   2. Copy the path of this file on your computer;
   3. pip install it with ``` pip install [path].whl ```


## With pip+git

```bash
pip install git+https://github.com/JeremieGince/PythonBasicTools
```


--------------------------------------------------------------------------------

[![Star on GitHub](https://img.shields.io/github/stars/JeremieGince/PythonBasicTools.svg?style=social)](https://github.com/JeremieGince/PythonBasicTools/stargazers)
