# Contributing to pythonbible
We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code (or documentation)
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## We Develop with Github
We use github to host code, to track issues and feature requests, as well as accept pull requests.

## Any contributions you make will be under the MIT Software License
In short, when you submit code changes, your submissions are understood to be under the same [MIT License](http://choosealicense.com/licenses/mit/) that covers the project. Feel free to contact the maintainers if that's a concern.

## Report bugs using Github's [issues](https://github.com/avendesora/pythonbible/issues)
We use GitHub issues to track public bugs. Report a bug by [opening a new issue](https://github.com/avendesora/pythonbible/issues/new/choose); it's that easy!

## Code style and code quality
Type hints are optional, but strongly recommended.

Tests are not optional.

All code submitted should be formatted by [black](https://github.com/psf/black) pre-commit.

## License
By contributing, you agree that your contributions will be licensed under its MIT License.

## References
This document was adapted from the open-source contribution guidelines found [here](https://gist.github.com/briandk/3d2e8b3ec8daf5a27a62).
