# Python-BPF
This is an LLVM IR generator for eBPF programs in Python. We use `llvmlite` to generate LLVM IR code from pure Python code. This is then compiled to LLVM object files, which can be loaded into the kernel for execution.

## Development
Step 0. Make a virtual environment and activate it using `python3 -m venv .venv && source .venv/bin/activate`.  
Step 1. Run `make install` to install the required dependencies.  
Step 2. Run `make` to see the compilation output of the example.  
Step 3. Run `check.sh` to check if generated object file passes through the verifier inside the examples directory.  
Step 4. Run `make` in the `examples/c-form` directory to modify the example C BPF program to check the actual LLVM IR generated by clang.  

### Development Notes
Run ` ./check.sh run execve2.o;` in examples folder

## Authors
- [@r41k0u](https://github.com/r41k0u)
- [@varun-r-mallya](https://github.com/varun-r-mallya)
