# Python-BPF
<p align="center">
<a href="https://www.python.org/downloads/release/python-3080/"><img src="https://img.shields.io/badge/python-3.8-blue.svg"></a>
<a href="https://pypi.org/project/pythonbpf"><img src="https://badge.fury.io/py/pythonbpf.svg"></a>
</p>

This is an LLVM IR generator for eBPF programs in Python. We use llvmlite to generate LLVM IR from pure Python. This is then compiled to LLVM object files, which can be loaded into the kernel for execution. We do not rely on BCC to do our compilation.

# DO NOT USE IN PRODUCTION. IN DEVELOPMENT.

## Video Demo
[Video demo for code under demo/](https://youtu.be/eMyLW8iWbks)

## Slide Deck
[Slide deck explaining the project](https://docs.google.com/presentation/d/1DsWDIVrpJhM4RgOETO9VWqUtEHo3-c7XIWmNpi6sTSo/edit?usp=sharing)

##  Installation
- Have `clang` installed.
- `pip install pythonbpf`

## Usage
```python
# pythonbpf_example.py
from pythonbpf import bpf, map, bpfglobal, section, compile
from pythonbpf.helpers import bpf_ktime_get_ns
from pythonbpf.maps import HashMap

from ctypes import c_void_p, c_int64, c_int32, c_uint64

@bpf
@map
def last() -> HashMap:
    return HashMap(key=c_uint64, value=c_uint64, max_entries=1)

@bpf
@section("tracepoint/syscalls/sys_enter_execve")
def hello(ctx: c_void_p) -> c_int32:
    print("entered")
    return c_int32(0)

@bpf
@section("tracepoint/syscalls/sys_exit_execve")
def hello_again(ctx: c_void_p) -> c_int64:
    print("exited")
    key = 0
    tsp = last().lookup(key)
    print(tsp)
    ts = bpf_ktime_get_ns()
    return c_int64(0)

@bpf
@bpfglobal
def LICENSE() -> str:
    return "GPL"

def some_normal_function():
    print("normal function")

# compiles and dumps object file in the same directory
compile()
```
- Run `python pythonbpf_example.py` to get the compiled object file that can be then loaded into the kernel.

## Development
- Make a virtual environment and activate it using `python3 -m venv .venv && source .venv/bin/activate`.  
- Run `make install` to install the required dependencies.  
- Run `make` to see the compilation output of the example.  
- Run `check.sh` to check if generated object file passes through the verifier inside the examples directory.  
- Run `make` in the `examples/c-form` directory to modify the example C BPF program to check the actual LLVM IR generated by clang.

### Development Notes
- Run ` ./check.sh check execve2.o;` in examples folder to check if the object code passes the verifier.
- Run ` ./check.sh run execve2.o;` in examples folder to run the object code using `bpftool`.

## Authors
- [@r41k0u](https://github.com/r41k0u)
- [@varun-r-mallya](https://github.com/varun-r-mallya)
