#!/usr/bin/env python3
# coding=utf-8
# PY test script file name must start with "test" to allow automatic recognition by PyCharm
# import
from unittest import TestCase
from copy import deepcopy
from datetime import datetime
from pythoncommontools.objectUtil.objectUtil import convertObjectToOrderedDict
from pythoncommontools.objectUtil.POPO import POPO, normalizePopoAttribut
from pythoncommontools.jsonEncoderDecoder.simpleJsonEncoderDecoder import convertObjectToJsonDict
from test.commonComplexObjects import testSampleBoolean, testSampleNonStandardObject ,testSampleNumeric ,testSampleSequence ,testSampleString ,testSampleBinary ,testSampleSet ,testSampleDictionnary ,testSampleObject, getSampleSequence, getSampleBinary, getSampleSet, getSampleDictionnary, getSampleObject
# define test
# INFO : this class also test POPO
defaultTimestamp = str(datetime.fromtimestamp(0))
class testObjectUtil(TestCase):
    def testBoolean(self):
        expectedDict = {'sampleBoolean': True, 'className': 'SampleBoolean', 'module': 'test.commonComplexObjects'}
        differentObject = deepcopy(testSampleBoolean)
        differentObject.sampleBoolean = False
        self.checkSampleObject(testSampleBoolean, expectedDict, differentObject)
        pass
    def testNonStandardObject(self):
        expectedDict = {'dateTime': str(testSampleNonStandardObject.dateTime), 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}
        differentObject = {'dateTime': str(datetime.now()), 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}
        self.checkSampleObject(testSampleNonStandardObject, expectedDict, differentObject)
        pass
    def testNumeric(self):
        expectedDict = {'sampleInt': 1, 'sampleFloat': 2.3, 'sampleComplex': (4+5j), 'className': 'SampleNumeric', 'module': 'test.commonComplexObjects'}
        differentObject = deepcopy(testSampleNumeric)
        differentObject.sampleInt = 2
        self.checkSampleObject(testSampleNumeric, expectedDict, differentObject)
        pass
    def testSequence(self):
        expectedDict = {'sampleList': [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 2.6, 3, b'\xa1\xb2\xc3', b'poiuytr', None, (1+5j), frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})}, frozenset({True, 4.8, b'mlkjhgf', (7+0j), 9, b'\xd4\xe5\xf6', None, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})}), {True: None, False: 1, 'a': 1, 'b': 2.3, 'c': (4+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 'k': {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'23', b'01'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, 'l': None, 2: (4+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 10: 1, 11: None, 9.1: 2.3, 8.2: (4+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 0.1: {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'23', b'01'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, (9+1j): 2.3, (8+2j): (4+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], (1+9j): {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'23', b'01'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, b'az': 1, b'by': 2.3, b'cx': (4+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], b'ju': {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'23', b'01'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, b'nb': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], b'lm': {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'23', b'01'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'23', b'01'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], frozenset({'jack', 12.3}): {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'23', b'01'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, {'attributSet': {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, 'attributFrozenset': frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None}), 'attributList': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 'attributTuple': (False, 0, 8.5, (6+4j), b'\xa9\xb8\xc7', bytearray(b'm^O'), b'ascfthn', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})), 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, 'className': 'SampleObject', 'module': 'test.commonComplexObjects'}], 'sampleTuple': (True, 9, 8.7, (6+5j), b'\xa1\xb2\xc3', bytearray(b'M^o'), b'mlkqsdg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, (False, 0, 8.5, (6+4j), b'\xa9\xb8\xc7', bytearray(b'm^O'), b'ascfthn', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})), {True, 2.6, 3, b'\xa1\xb2\xc3', b'poiuytr', None, (1+5j), frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})}, frozenset({True, 4.8, b'mlkjhgf', (7+0j), 9, b'\xd4\xe5\xf6', None, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})}), {'attributSet': {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, 'attributFrozenset': frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None}), 'attributList': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})], 'attributTuple': (False, 0, 8.5, (6+4j), b'\xa9\xb8\xc7', bytearray(b'm^O'), b'ascfthn', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'wqaxszcd', b'M^o', 9, None})), 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, 'className': 'SampleObject', 'module': 'test.commonComplexObjects'}), 'sampleRange': range(1, 10), 'className': 'SampleSequence', 'module': 'test.commonComplexObjects'}
        differentObject = getSampleSequence()
        differentObject.sampleList = list()
        self.checkSampleObject(testSampleSequence, expectedDict, differentObject,getSampleSequence)
        pass
    def testString(self):
        expectedDict = {'sampleString': 'hello world!', 'className': 'SampleString', 'module': 'test.commonComplexObjects'}
        differentObject = deepcopy(testSampleString)
        differentObject.sampleString = ''
        self.checkSampleObject(testSampleString, expectedDict, differentObject)
        pass
    def testBinary(self):
        expectedDict = {'sampleBytes': b'\xf0\xf1\xf2', 'sampleBytearray': bytearray(b'\xe3\xe4\xe5'), 'sampleMemoryview': b'abcefg', 'className': 'SampleBinary', 'module': 'test.commonComplexObjects'}
        differentObject = getSampleBinary()
        differentObject.sampleBytes = bytes()
        self.checkSampleObject(testSampleBinary, expectedDict, differentObject, getSampleBinary)
        pass
    def testSet(self):
        expectedDict = {'sampleSet': {0, True, 1.2, None, (3+4j), b'abcefg', frozenset({True, 2.6, 3, b'wqazsxc', None, b'>N^', (1+9j)}), b'\xf0\xf1\xf2'}, 'sampleFrozenset': frozenset({True, b'\xe3\xe4\xe5', 8.7, 9, None, frozenset({True, 2.6, 3, b'wqazsxc', None, b'>N^', (1+9j)}), (6+5j), b'azerty'}), 'className': 'SampleSet', 'module': 'test.commonComplexObjects'}
        differentObject = getSampleSet()
        differentObject.sampleSet = set()
        self.checkSampleObject(testSampleSet, expectedDict, differentObject, getSampleSet)
        pass
    def testDictionnary(self):
        expectedDict = {'sampleDictionnary': {True: None, False: 1, 'a': 1, 'b': 2.3, 'c': (4+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], 'k': {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'1', '0'}): 'azerty', frozenset({b'23', b'01'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'eswascz', b'plmoijk'}): b'abcefg', frozenset({2, 3}): [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, 'l': None, 2: (4+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], 10: 1, 11: None, 9.1: 2.3, 8.2: (4+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], 0.1: {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'1', '0'}): 'azerty', frozenset({b'23', b'01'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'eswascz', b'plmoijk'}): b'abcefg', frozenset({2, 3}): [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, (9+1j): 2.3, (8+2j): (4+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], (1+9j): {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'1', '0'}): 'azerty', frozenset({b'23', b'01'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'eswascz', b'plmoijk'}): b'abcefg', frozenset({2, 3}): [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, b'az': 1, b'by': 2.3, b'cx': (4+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], b'ju': {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'1', '0'}): 'azerty', frozenset({b'23', b'01'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'eswascz', b'plmoijk'}): b'abcefg', frozenset({2, 3}): [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, b'nb': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], b'lm': {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'1', '0'}): 'azerty', frozenset({b'23', b'01'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'eswascz', b'plmoijk'}): b'abcefg', frozenset({2, 3}): [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'1', '0'}): 'azerty', frozenset({b'23', b'01'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'eswascz', b'plmoijk'}): b'abcefg', frozenset({2, 3}): [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], frozenset({'jack', 12.3}): {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'1', '0'}): 'azerty', frozenset({b'23', b'01'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'eswascz', b'plmoijk'}): b'abcefg', frozenset({2, 3}): [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, b'\x1a+<', b'mplokij', None, (1+5j)}, frozenset({True, 2.6, (3+0j), b'M^o', 9, b'wqaxszcd', None})], {True, 2.6, 3, b'poiuytr', None, (1+5j), b'\xa1\xb2\xc3'}, frozenset({True, 4.8, (7+0j), 9, b'mlkjhgf', None, b'\xd4\xe5\xf6'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, 'className': 'SampleDictionnary', 'module': 'test.commonComplexObjects'}
        differentObject = getSampleDictionnary()
        differentObject.sampleDictionnary = {}
        self.checkSampleObject(testSampleDictionnary, expectedDict, differentObject, getSampleDictionnary)
        pass
    def testObject(self):
        expectedDict = {'sampleBoolean': True, 'sampleNumeric': {'sampleInt': 1, 'sampleFloat': 2.3, 'sampleComplex': (4+5j), 'className': 'SampleNumeric', 'module': 'test.commonComplexObjects'}, 'sampleSequence': {'sampleList': [True, 0, 1.2, (3+4j), b'\xf0\xf1\xf2', bytearray(b'\xe3\xe4\xe5'), b'abcefg', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], {True, 2.6, 3, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'}), b'\xa1\xb2\xc3', None, (1+5j), b'poiuytr'}, frozenset({True, b'mlkjhgf', 4.8, b'\xd4\xe5\xf6', (7+0j), 9, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'}), None}), {True: None, False: 1, 'a': 1, 'b': 2.3, 'c': (4+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 'k': {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'01', b'23'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, 'l': None, 2: (4+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 10: 1, 11: None, 9.1: 2.3, 8.2: (4+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 0.1: {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'01', b'23'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, (9+1j): 2.3, (8+2j): (4+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], (1+9j): {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'01', b'23'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, b'az': 1, b'by': 2.3, b'cx': (4+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'ju': {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'01', b'23'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, b'nb': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'lm': {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'01', b'23'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'01', b'23'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], frozenset({'jack', 12.3}): {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'01', b'23'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}], 'sampleTuple': (3, 4.5), 'sampleRange': range(1, 10), 'className': 'SampleSequence', 'module': 'test.commonComplexObjects'}, 'sampleString': 'hello world!', 'sampleBinary': {'sampleBytes': b'\xf0\xf1\xf2', 'sampleBytearray': bytearray(b'\xe3\xe4\xe5'), 'sampleMemoryview': b'abcefg', 'className': 'SampleBinary', 'module': 'test.commonComplexObjects'}, 'sampleSet': {'sampleSet': {True, 2.6, 3, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'}), b'\xa1\xb2\xc3', None, (1+5j), b'poiuytr'}, 'sampleFrozenset': frozenset({True, b'mlkjhgf', 4.8, b'\xd4\xe5\xf6', (7+0j), 9, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'}), None}), 'className': 'SampleSet', 'module': 'test.commonComplexObjects'}, 'sampleDictionnary': {'sampleDictionnary': {True: None, False: 1, 'a': 1, 'b': 2.3, 'c': (4+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 'k': {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'01', b'23'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, 'l': None, 2: (4+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 10: 1, 11: None, 9.1: 2.3, 8.2: (4+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 0.1: {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'01', b'23'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, (9+1j): 2.3, (8+2j): (4+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], (1+9j): {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'01', b'23'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, b'az': 1, b'by': 2.3, b'cx': (4+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'ju': {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'01', b'23'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, b'nb': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'lm': {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'01', b'23'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'01', b'23'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], frozenset({'jack', 12.3}): {False: 9, True: 9, 'a': 9, 'b': 8.7, 'c': (6+5j), 'd': 'azerty', 'e': b'\xf0\xf1\xf2', 'f': bytearray(b'\xe3\xe4\xe5'), 'g': b'abcefg', 'h': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 'j': None, 2: (6+5j), 3: 'azerty', 4: b'\xf0\xf1\xf2', 5: bytearray(b'\xe3\xe4\xe5'), 6: b'abcefg', 7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 9: None, 10.0: 9, 9.1: 8.7, 8.2: (6+5j), 7.3: 'azerty', 6.4: b'\xf0\xf1\xf2', 5.5: bytearray(b'\xe3\xe4\xe5'), 4.6: b'abcefg', 3.7: [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], 1.9: None, (9+1j): 8.7, (8+2j): (6+5j), (7+3j): 'azerty', (6+4j): b'\xf0\xf1\xf2', (5+5j): bytearray(b'\xe3\xe4\xe5'), (4+6j): b'abcefg', (3+7j): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], (2+8j): None, b'az': 9, b'by': 8.7, b'cx': (6+5j), b'dw': 'azerty', b'ev': b'\xf0\xf1\xf2', b'fu': bytearray(b'\xe3\xe4\xe5'), b'gt': b'abcefg', b'hs': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'hy': None, b'er': 1, b'ty': 2.3, b'ui': (4+5j), b'op': 'azerty', b'qs': b'\xf0\xf1\xf2', b'df': bytearray(b'\xe3\xe4\xe5'), b'gh': b'abcefg', b'jk': [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], b'wx': None, frozenset({0, 1}): 1, frozenset({2.0, 3.1}): 2.3, frozenset({1j, (2+3j)}): (4+5j), frozenset({'0', '1'}): 'azerty', frozenset({b'01', b'23'}): b'\xf0\xf1\xf2', frozenset({1, b'32'}): bytearray(b'\xe3\xe4\xe5'), frozenset({b'plmoijk', b'eswascz'}): b'abcefg', frozenset({2, 3}): [False, 5, 6.7, (8+9j), b'\x0f\x1f/', bytearray(b'>N^'), b'azerty', None, {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}, {True, 4.8, 7, None, (1+5j), b'mplokij', b'\x1a+<'}, frozenset({True, 2.6, (3+0j), b'M^o', 9, None, b'wqaxszcd'})], frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, frozenset({None}): None, 'dateTime': {'dateTime': defaultTimestamp, 'className': 'SampleNonStandardObject', 'module': 'test.commonComplexObjects'}}, 'className': 'SampleDictionnary', 'module': 'test.commonComplexObjects'}, 'className': 'SampleObject', 'module': 'test.commonComplexObjects'}
        differentObject = getSampleObject()
        differentObject.X = 0
        self.checkSampleObject(testSampleObject, expectedDict, differentObject, getSampleObject)
        pass
    def checkSampleObject(self,originalObject,expectedDict,differentObject,cloneFunction=deepcopy):
        # compare dicts
        actualDict = originalObject.dumpToDict()
        self.assertEqual(actualDict,expectedDict,"dicts are different")
        # INFO : string check is not important
        # compare hashes
        hashesSet = set(((originalObject.__hash__(),originalObject.__hash__())))
        self.assertEqual(len(hashesSet),1,"hashes are different")
        # compare equals
        if (cloneFunction==deepcopy):
            clonedObject = cloneFunction(originalObject)
        else:
            clonedObject = cloneFunction()
        self.assertEqual(clonedObject,originalObject,"identical objects are different")
        self.assertNotEqual(differentObject,originalObject,"different objects are identical")
        # dump & load simple JSON
        json = originalObject.dumpToSimpleJson()
        reloadedObject = POPO.loadFromSimpleJson(json)
        self.assertEqual(type(originalObject),type(reloadedObject),"objects have different types")
        # load from dict
        reloadedObject = POPO.loadFromDict(actualDict)
        self.checkExactSameObject(originalObject, reloadedObject)
        # dump & load complex JSON
        json = originalObject.dumpToComplexJson()
        reloadedObject = POPO.loadFromComplexJson(json)
        self.checkExactSameObject(originalObject, reloadedObject)
        pass
    def checkExactSameObject(self,originalObject,reloadedObject):
        self.assertEqual(originalObject,reloadedObject,"objects are different")
        self.assertEqual(originalObject.sampleFunction(),reloadedObject.sampleFunction(),"objects behave differently")
        pass
    def testMemoryViewConversion(self):
        bytesList = b'abcefg'
        memoryView = memoryview(bytesList)
        result = convertObjectToOrderedDict(memoryView)
        self.assertEqual(result, bytesList, "memory view is not correctly converted into ordered dict")
        result = convertObjectToJsonDict(memoryView)
        self.assertEqual(result, [97, 98, 99, 101, 102, 103], "memory view is not correctly converted into ordered dict")
        pass
    def testPopoInObject(self):
        class ContainerClass():
            def __init__(self, innerPopo):
                self.innerPopo = innerPopo
        containerObject = ContainerClass(testSampleObject)
        normalizedObject = normalizePopoAttribut(containerObject)
        self.assertEqual(type(containerObject),type(normalizedObject),"normalized objects type (with inner POPO) are different")
        self.assertNotEqual(containerObject,normalizedObject,"normalized objects (with inner POPO) the same")
        pass
    pass
pass
