#!/usr/bin/env python

import setuptools
import distutils.core
import distutils.command.build


# Local imports

import pythonect


# Functions

def _mk_versiondotpy():

    with open('pythonect/_version.py', 'wt') as f:

        f.write('# DO NOT EDIT THIS FILE! It is automatically generated by setup.py\n__version__ = \'' + pythonect.__version__ + '\'')


# Classes

class Build(distutils.command.build.build):

    def run(self):

        # Generate `_version.py`

        _mk_versiondotpy()

        return distutils.command.build.build.run(self)


# Entry Point

if __name__ == "__main__":

    setupconf = dict(
            name='Pythonect',
            version=pythonect.__version__,
            author='Itzik Kotler',
            author_email='xorninja@gmail.com',
            url='http://www.pythonect.org/',
            license='BSD',
            description='A general-purpose dataflow programming language based on Python, written in Python',

            long_description=open('README.rst').read(),

            scripts=['bin/pythonect'],

            packages=setuptools.find_packages(),

            classifiers=['Development Status :: 4 - Beta',
                         'License :: OSI Approved :: BSD License',
                         'Operating System :: OS Independent',
                         'Programming Language :: Python',
                         'Programming Language :: Python :: 2.7',
            ],

            install_requires=['ply>=3.4'],

            cmdclass={'build': Build}

    )

    setuptools.setup(**setupconf)
