# Copyright 2023-2025 Geoffrey R. Scheller
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from collections.abc import Callable, Iterable, Iterator
from typing import Never, TypeVar

__all__ = ['CAF', 'caf']

I = TypeVar('I')
T = TypeVar('T')


class CAF[I]():

    L = TypeVar('L')
    R = TypeVar('R')
    U = TypeVar('U')

    def __init__(
            self,
            items: Iterable[I] | None = None,
            capacity: int = 2
        ) -> None: ...

    def __iter__(self) -> Iterator[I]: ...

    def __reversed__(self) -> Iterator[I]: ...

    def __repr__(self) -> str: ...

    def __str__(self) -> str: ...

    def __bool__(self) -> bool: ...

    def __len__(self) -> int: ...

    def __getitem__(self, idx: int) -> I: ...

    def __setitem__(self, idx: int, val: I) -> None: ...

    def __delitem__(self, idx: int) -> None: ...

    def __eq__(self, other: object) -> bool: ...

    def pushl(self, item: I) -> None: ...

    def pushr(self, item: I) -> None: ...

    def popl(self) -> I | Never: ...

    def popr(self) -> I | Never: ...

    def popld(self, default: I) -> I: ...

    def poprd(self, default: I) -> I: ...

    def poplt(self, maximum: int) -> tuple[I, ...]: ...

    def poprt(self, maximum: int) -> tuple[I, ...]: ...

    def rotl(self, n: int = 1) -> None: ...

    def rotr(self, n: int = 1) -> None: ...

    def map[U](self, f: Callable[[I], U]) -> CAF[U]: ...

    def foldl[L](self, f: Callable[[L, I], L], start: L | None = None) -> L | Never: ...

    def foldr[R](self, f: Callable[[I, R], R], start: R | None = None) -> R | Never: ...

    def capacity(self) -> int: ...

    def empty(self) -> None: ...

    def fraction_filled(self) -> float: ...


def caf[T](*items: T, capacity: int = 2) -> CAF[T]: ...
