from collections.abc import Callable, Iterable, Iterator
from typing import overload

__all__ = ['CAF', 'caf']

class CAF[I]:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, items: Iterable[I]) -> None: ...
    @overload
    def __init__(self, items: Iterable[I], capacity: int) -> None: ...
    def __iter__(self) -> Iterator[I]: ...
    def __reversed__(self) -> Iterator[I]: ...
    def __bool__(self) -> bool: ...
    def __len__(self) -> int: ...
    def __getitem__(self, idx: int) -> I: ...
    def __setitem__(self, idx: int, val: I) -> None: ...
    def __delitem__(self, idx: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def pushl(self, item: I) -> None: ...
    def pushr(self, item: I) -> None: ...
    def popl(self) -> I: ...
    def popr(self) -> I: ...
    def popld(self, default: I) -> I: ...
    def poprd(self, default: I) -> I: ...
    def poplt(self, maximum: int) -> tuple[I, ...]: ...
    def poprt(self, maximum: int) -> tuple[I, ...]: ...
    def rotl(self, n: int = 1) -> None: ...
    def rotr(self, n: int = 1) -> None: ...
    def map[U](self, f: Callable[[I], U]) -> CAF[U]: ...
    @overload
    def foldl[L](self, f: Callable[[I, I], I]) -> I: ...
    @overload
    def foldl[L](self, f: Callable[[L, I], L], start: L) -> L: ...
    @overload
    def foldr[R](self, f: Callable[[I, I], I]) -> I: ...
    @overload
    def foldr[R](self, f: Callable[[I, R], R], start: R) -> R: ...
    def capacity(self) -> int: ...
    def empty(self) -> None: ...
    def fraction_filled(self) -> float: ...

def caf[T](*items: T, capacity: int = 2) -> CAF[T]: ...
