# Copyright 2024-2025 Geoffrey R. Scheller
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Circular Array
--------------

.. admonition:: Stateful circular array data structures.

    +-------------------------------------+-------------------------------------------+
    | Module                              | Description                               |
    +=====================================+===========================================+
    | **pythonic_fp.circulararray.auto**  | Variable storage capacity circular array. |
    +-------------------------------------+-------------------------------------------+
    | **pythonic_fp.circulararray.fixed** | Fixed storage capacity circular array.    |
    +-------------------------------------+-------------------------------------------+

    - O(1) pops and pushes either end
    - O(1) size determination
    - O(1) indexing

"""

__author__ = 'Geoffrey R. Scheller'
__copyright__ = 'Copyright (c) 2023-2026 Geoffrey R. Scheller'
__license__ = 'Apache License 2.0'
