# Copyright 2023-2024 Geoffrey R. Scheller
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from collections.abc import Callable, Iterable, Iterator
from typing import TypeVar
from pythonic_fp.fptools.maybe import MayBe

__all__ = ['LIFOQueue', 'lifo_queue']

D = TypeVar('D')

class LIFOQueue[D]:
    __slots__ = ('_ca',)

    def __init__(self, *dss: Iterable[D]) -> None: ...
    def __bool__(self) -> bool: ...
    def __len__(self) -> int: ...
    def __eq__(self, other: object) -> bool: ...
    def __iter__(self) -> Iterator[D]: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...
    def copy(self) -> LIFOQueue[D]: ...
    def push(self, *ds: D) -> None: ...
    def pop(self) -> MayBe[D]: ...
    def peak(self) -> MayBe[D]: ...
    def fold[T](self, f: Callable[[T, D], T], start: T | None = None) -> MayBe[T]: ...
    def map[U](self, f: Callable[[D], U]) -> LIFOQueue[U]: ...

def lifo_queue[D](*ds: D) -> LIFOQueue[D]: ...
