from collections.abc import Callable, Iterator
from pythonic_fp.iterables.merging import MergeEnum
from typing import Never, SupportsIndex, overload

__all__ = ['FTuple']

class FTuple[D](tuple[D, ...]):
    def __reversed__(self) -> Iterator[D]: ...
    def __eq__(self, other: object) -> bool: ...
    @overload
    def __getitem__(self, idx: SupportsIndex) -> D: ...
    @overload
    def __getitem__(self, idx: slice) -> tuple[D, ...]: ...
    def foldl[L](self, f: Callable[[L, D], L], /, start: L | None = None, default: L | None = None) -> L: ...
    def foldr[R](self, f: Callable[[D, R], R], /, start: R | None = None, default: R | None = None) -> R: ...
    def copy(self) -> FTuple[D]: ...
    def __add__(self, other: object) -> tuple[D, ...]: ...
    def __mul__(self, num: SupportsIndex) -> tuple[D, ...]: ...
    def __rmul__(self, num: SupportsIndex) -> tuple[D, ...]: ...
    def accummulate[L](self, f: Callable[[L, D], L], s: L | None = None, /) -> FTuple[L]: ...
    def map[U](self, f: Callable[[D], U], /) -> FTuple[U]: ...
    def bind[U](self, f: Callable[[D], FTuple[U]], merge_type: MergeEnum = ..., yield_partials: bool = False) -> FTuple[U] | Never: ...
